# -*- coding: utf-8 -*-

from . import _yp_core as core

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri, const as rm_const


class YpPodScalerConfig(core.YPConfigBase):
    name = "yp_pod_scaler"

    class JG(core.YPJobGraph):
        yp_test_cubes = [
            core.YPTestCube(
                name="test_yp",
                paths=list(core.YP_TEST_PATHS),
            ),
        ]

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "yp/server/pod_scaler/bin"
        secret = "sec-01fgrcn7q2t99yw91w2jkrpysc"
        sb_owner_group = "YP"

        ya_make_abs_paths_glob = [
            "yp/client/**",
            "yp/server/**",
            "yp/yp_proto/**",
            "yt/yt/orm/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="yp_pod_scaler_binary",
                    data=ri.SandboxResourceData("YP_POD_SCALER_BINARY"),
                    build_data=ri.BuildData(
                        target="yp/server/pod_scaler/bin/ypserver-pod-scaler",
                    ),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService(name)
                                for name in (
                                    "myt_yp_yp_pod_scalers",
                                    "iva_yp_yp_pod_scalers",
                                    "man_yp_yp_pod_scalers",
                                    "vla_yp_yp_pod_scalers",
                                    "sas_yp_yp_pod_scalers",
                                )
                            ],
                            stage=rm_const.ReleaseStatus.stable
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("man_yp_pre_yp_pod_scalers"),
                            stage=rm_const.ReleaseStatus.prestable
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("sas_yp_test_yp_pod_scalers"),
                            stage=rm_const.ReleaseStatus.testing
                        ),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "s-berdnikov",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "s-berdnikov"
            queue = "YPREL"
            dev_queue = "YP"
            summary_template = u"Release YP Pod Scaler {}"
            workflow = {}
            followers = [
                "s-berdnikov",
            ]
            add_commiters_as_followers = False
            deadline = 14
            important_changes_limit = 1000
            notify_on_component_versions_change_to_feature_tickets = core.NOTIFY_ON_COMPONENT_VERSION_CHANGE_TO_FEATURE_TICKETS

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "yp/releases/pod-scaler"
        dirs = [
            "arcadia/yp/client",
            "arcadia/yp/server/lib",
            "arcadia/yp/server/pod_scaler",
            "arcadia/yp/yp_proto",
            "arcadia/yt/yt/orm",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        branch_name = "yp/pod_scaler"
        tag_name = "yp/pod_scaler"
