from ._yp_core import ya_make_test_params

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.cube import base as cube_base
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.core import releasable_items as ri, const as rm_const

from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class YpProvisorConfig(configs.ReferenceCIConfig):
    name = "yp_provisor"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="yp"),
        login="robot-yp-releaser",
    )

    class JG(basic_build_presets.SingleBuildYaPackageJGCfg):
        # NB: preset does not include running tests, so we have to patch job graph.
        @jg_flow.release_flow(stages=basic_build_presets.DEFAULT_RELEASE_FLOW_STAGES)
        def release(self):
            graph = super(YpProvisorConfig.JG, self).release(self)
            main_entry = graph.get(dummy_cubes.RMMainGraphEntry.NAME)
            release_entry = graph.get("release_stage_entry")

            test_batches = {
                "test_yp_provisor": ["yp/provisor"],
            }
            for name, paths in test_batches.items():
                cube = jg_cube.Cube(
                    name=name,
                    needs=[main_entry],
                    task="common/arcadia/ya_make",
                    input=cube_base.CubeInput(**ya_make_test_params(paths)),
                )
                release_entry.add_requirement(cube)
                graph.add(cube)

            return graph

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "yp/provisor"
        secret = "sec-01fgrcn7q2t99yw91w2jkrpysc"
        sb_owner_group = "YP"

        ya_make_abs_paths_glob = [
            "yp/client/**",
            "yp/go/**",
            "yp/provisor/**",
            "yp/server/**",
            "yp/yp_proto/**",
            "yt/yt/orm/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="yp_provisor_package",
                    data=ri.SandboxResourceData("YP_PROVISOR_PACKAGE"),
                    build_data=ri.BuildData(
                        target="yp/provisor/package.json",
                    ),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService(name)
                                for name in (
                                    "myt_yp_yp_provisor",
                                    "iva_yp_yp_provisor",
                                    "man_yp_yp_provisor",
                                    "vla_yp_yp_provisor",
                                    "sas_yp_yp_provisor",
                                    "multi_xdc_yp_yp_provisor",
                                )
                            ],
                            stage=rm_const.ReleaseStatus.stable
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("man_yp_pre_yp_provisor"),
                            stage=rm_const.ReleaseStatus.prestable
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("sas_yp_test_yp_provisor"),
                            stage=rm_const.ReleaseStatus.testing
                        ),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "se4min",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "se4min"
            queue = "YPREL"
            dev_queue = "YP"
            summary_template = u"Release YP Provisor {}"
            workflow = {}
            followers = [
                "se4min",
            ]
            add_commiters_as_followers = False
            deadline = 14
            important_changes_limit = 1000

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "yp/releases/provisor"
        dirs = [
            "arcadia/yp/client",
            "arcadia/yp/go",
            "arcadia/yp/provisor",
            "arcadia/yp/server",
            "arcadia/yp/yp_proto",
            "arcadia/yt/yt/orm",
        ]

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        branch_name = "yp/provisor"
        tag_name = "yp/provisor"
