# -*- coding: utf-8 -*-

from sandbox.projects.common.constants import constants as common_const
from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


_META_TEST_TARGETS = ";".join([
    "infra/yp_service_discovery",
])


class YpServiceDiscoveryCfg(configs.ReferenceBranchedConfig):
    name = "yp_service_discovery"
    responsible = "elshiko"
    display_name = "YP Service Discovery"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "SEARCH-RELEASERS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _trunk_part(self):
                trunk_part = super(self.__class__, self)._trunk_part
                trunk_part.append(
                    jg_test.JobGraphElementRunIceFlame(
                        config_file="yp_service_discovery.conf",
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                            "frequency": (jg_utils.TestFrequency.DEFINED_BY_CODE, None),
                            "next_revision_custom_schedule": jg_utils.CustomSchedule(
                                time_interval_list=[(13, 19)],
                                weekday_list=[0, 1, 2, 3, 4],
                                seconds_from_last_run_commit=1.5 * 3600,
                                once_a_day=True,
                            ),
                            "job_name_parameter": "RELEASE",
                        },
                        ctx={
                            "release_item_name": "yp_service_discovery",
                            "service_name": "msk_yp_service_discovery",
                            "fail_if_service_version_cannot_be_determined": True,
                            "check_production_version": True,
                        },
                    ),
                )
                trunk_part.append(
                    jg_test.JobGraphElementRunIceFlame(
                        config_file="yp_service_discovery.conf",
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                            "frequency": (jg_utils.TestFrequency.DEFINED_BY_CODE, None),
                            "next_revision_custom_schedule": jg_utils.CustomSchedule(
                                time_interval_list=[(11, 12)],
                                weekday_list=[0],
                                seconds_from_last_run_start_time=7 * 24 * 3600,  # every week
                                last_run_finished=True,
                                once_a_day=True,
                            ),
                            "job_name_parameter": "WEEKLY",
                        },
                        ctx={
                            "release_item_name": "yp_service_discovery",
                            "service_name": "msk_yp_service_discovery",
                        },
                    ),
                )

                return trunk_part

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                for build_item, r_type, result_rd, art in [
                    (
                        "EXECUTABLE",
                        "YP_SERVICE_DISCOVERY",
                        "YP Service Discovery executable",
                        "yp_service_discovery/yp_service_discovery"
                    ),
                    (
                        "INSTANCECTL_CONF",
                        "YP_SERVICE_DISCOVERY_INSTANCECTL_CONF",
                        "instancectl.conf for YP Service Discovery",
                        "instancectl_conf/instancectl.conf"
                    ),
                    (
                        "UNIFIED_AGENT_CONFIG",
                        "YP_SERVICE_DISCOVERY_UNIFIED_AGENT_CONFIG",
                        "Unified Agent config for YP Service Discovery",
                        "unified_agent/ua_config.yml.tmpl"
                    ),
                ]:
                    branch_part.append(
                        jg_build.JobGraphElementBuildBranched(
                            task_name="YA_MAKE_RELEASE_TO_NANNY",
                            build_item=build_item,
                            out={r_type: 30},
                            ctx={
                                "targets": "infra/yp_service_discovery",
                                "arts": "infra/yp_service_discovery/deploy/{}".format(art),
                                "result_rt": r_type,
                                "result_rd": result_rd,
                                "result_single_file": True,
                                common_const.USE_AAPI_FUSE: True,
                                common_const.ALLOW_AAPI_FALLBACK: True,
                            },
                            job_params={
                                "apiargs": {
                                    "hidden": False,
                                    "requirements": {
                                        "platform": "linux",
                                        "disk_space": 15 * 1024 ** 3,  # 15 Gb
                                    }
                                },
                            }
                        ),
                    )
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="YP_SERVICE_DISCOVERY_DIFF_TEST",
                    ctx={
                        "requests_percentage": 0.1,
                        "yp_token_owner": "robot-yp-sd-test",
                    },
                    job_arrows=[
                        jg_job_triggers.JobTriggerBuild(
                            parent_job_data=[
                                jg_job_data.ParentDataResource(
                                    input_key="yp_service_discovery",
                                    resource_name="YP_SERVICE_DISCOVERY",
                                ),
                            ],
                            job_name_parameter="EXECUTABLE",
                        ),
                    ],
                    job_params={
                        "job_name_parameter": "DIFF_YP_MASTER",
                    },
                ))
                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="YA_MAKE",
                    ctx={
                        common_const.BUILD_SYSTEM_KEY: common_const.YMAKE_BUILD_SYSTEM,
                        common_const.BUILD_TYPE_KEY: common_const.RELEASE_BUILD_TYPE,
                        common_const.USE_AAPI_FUSE: True,
                        "targets": ";".join([
                            "infra/yp_service_discovery/deploy/tests",
                        ]),
                        "test": True,
                        "report_tests_only": True,
                        "disable_test_timeout": False,  # incompatible with --dist
                        "cache_test_results": False,
                        "tests_retries": 2,
                    },
                    job_arrows=[
                        jg_job_triggers.JobTriggerNewTag(
                            parent_job_data=[
                                jg_job_data.ParentDataOutput(
                                    input_key=common_const.ARCADIA_URL_KEY,
                                    output_key=common_const.ARCADIA_URL_KEY,
                                ),
                            ]
                        ),
                    ],
                    job_params={
                        "job_name_parameter": "ARCTESTS",
                        "apiargs": {
                            "requirements": {
                                "platform": "linux",
                                "ram": 50 * (1024 ** 3)  # 50 Gb
                            }
                        },
                    }
                ))
                branch_part.append(
                    jg_test.JobGraphElementMetaTestBranched(
                        job_params={
                            "job_name_parameter": "META_TESTS",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "apiargs": {
                                "kill_timeout": 2 * 60 * 60,  # 2 hour
                            }
                        },
                        ctx={
                            "targets": _META_TEST_TARGETS,
                            "disable_test_timeout": True,
                        },
                    )
                )
                branch_part.append(jg_test.JobGraphElementActionRunAcceptanceBranched(
                    parents=(
                        {
                            "job_type": rm_const.JobTypes.TEST,
                            "job_name_parameter": "DIFF_YP_MASTER"
                        },
                        {
                            "job_type": rm_const.JobTypes.TEST,
                            "job_name_parameter": "ARCTESTS"
                        },
                        {
                            "job_type": rm_const.JobTypes.BUILD,
                            "job_name_parameter": "INSTANCECTL_CONF"
                        },
                    ),
                    frequency=(jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                ))
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                release_stage = rm_const.ReleaseStatus.stable
                release_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=release_stage,
                    job_arrows=[
                        jg_job_triggers.JobTriggerBuild([
                            jg_job_data.ParentDataDict(
                                "component_resources",
                                "yp_service_discovery",
                                "YP_SERVICE_DISCOVERY",
                            ),
                        ], job_name_parameter="EXECUTABLE"),
                        jg_job_triggers.JobTriggerBuild([
                            jg_job_data.ParentDataDict(
                                "component_resources",
                                "instancectl_conf",
                                "YP_SERVICE_DISCOVERY_INSTANCECTL_CONF",
                            ),
                        ], job_name_parameter="INSTANCECTL_CONF"),
                        jg_job_triggers.JobTriggerBuild([
                            jg_job_data.ParentDataDict(
                                "component_resources",
                                "unified_agent_config",
                                "YP_SERVICE_DISCOVERY_UNIFIED_AGENT_CONFIG",
                            ),
                        ], job_name_parameter="UNIFIED_AGENT_CONFIG"),
                        jg_job_triggers.JobTriggerNewTag([
                            jg_job_data.ParentDataCtx("major_release_num", "branch_number_for_tag"),
                            jg_job_data.ParentDataCtx("minor_release_num", "new_tag_number"),
                            jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                        ]),
                    ],
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=release_stage,
                ))
                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            deploy_infos = [
                ri.NannyDeployInfo([
                    ri.DeployService("sas_yp_service_discovery"),
                    ri.DeployService("man_yp_service_discovery"),
                    ri.DeployService("vla_yp_service_discovery"),
                    ri.DeployService("msk_yp_service_discovery"),
                ]),
            ]
            return [
                ri.ReleasableItem(
                    name="yp_service_discovery",
                    data=ri.SandboxResourceData("YP_SERVICE_DISCOVERY"),
                    deploy_infos=deploy_infos,
                ),
                ri.ReleasableItem(
                    name="instancectl_conf",
                    data=ri.SandboxResourceData("YP_SERVICE_DISCOVERY_INSTANCECTL_CONF"),
                ),
                ri.ReleasableItem(
                    name="unified_agent_config",
                    data=ri.SandboxResourceData("YP_SERVICE_DISCOVERY_UNIFIED_AGENT_CONFIG"),
                ),
            ]

        release_followers_permanent = [
            "elshiko",
        ]

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "yp/discovery/releases/"
        dirs = [
            "arcadia/infra/yp_service_discovery",
            "arcadia/yp/cpp/yp",
            "arcadia/infra/libs/yp_replica",
        ]
        review_groups = [
            "yp-sd",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = []

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = configs.Responsible(
                abc=configs.Abc(component_id=3586, schedule_slug="yp-service-discovery-duty"),
                login="elshiko",
            )
            use_task_author_as_assignee = True
            queue = "YPSDREL"
            dev_queue = "DISCOVERY"
            summary_template = u"Приемка YP Service Discovery {}"
            add_commiters_as_followers = True
            deadline = 7
