# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


RESOURCES = [
    "HORIZON_AGENT_CONFIG_ZEN",
    "APP_HOST_STABLE_BRANCH_ZEN",
]


class ZenGraphsCfg(configs.ReferenceBranchedConfig):
    name = "zen_graphs"
    responsible = "comunodi"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "ZEN_AH_RELEASERS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                build_ctx={
                    "vertical": "ZEN",
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[
                        ri.NannyDeployInfo(ri.DeployService("production_app_host_vla_zen"), dashboards=["apphost_zen"]),
                    ],
                ) for resource in RESOURCES
            ]

        release_followers_permanent = [
            "comunodi",
        ]
        allow_old_releases = True
        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/zen"
        tag_name = "apphost/conf/zen"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "comunodi"
            queue = "ZEN"
            summary_template = u"Приемка графов ZEN {}"
            followers = [
                "comunodi",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = None
        observed_paths = [
            "arcadia/apphost/conf/backends/ZEN",
            "arcadia/apphost/conf/verticals/ZEN",
        ]
