# -*- coding: utf-8 -*-
from sandbox.projects.common.constants import constants as common_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class ZephyrCfg(configs.ReferenceBranchedConfig):
    name = "zephyr"
    responsible = "lebedev-aa"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "ZEPHYR"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementWikiNoStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseBase(
                        job_arrows=(
                            jg_job_triggers.JobTriggerWiki(),
                        )
                    ),
                ]

            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_ZEPHYR",
                build_ctx={
                    "target_resources": (
                        "ZEPHYR_BINARY",
                        "ZEPHYR_SERVICE_DISCOVERY_BINARY",
                        "LOGDUMP_BINARY",
                        "ZEPHYR_SERVAL_BINARY",
                    ),
                    common_const.TESTS_REQUESTED: True,
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="zephyr_binary_res_id",
                    data=ri.SandboxResourceData("ZEPHYR_BINARY", ttl=40),
                    deploy_infos=[ri.single_nanny_service("zephyr")],
                ),
            ]

        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        use_startrek = False

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["yappy-dev"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "zephyr/Releases/"
        observed_paths = [
            "arcadia/search/martylib",
            "arcadia/search/zephyr",
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "zephyr"
        tag_name = "zephyr"
