# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import json
import logging

import sandbox.projects.release_machine.security as rm_sec
import sandbox.projects.release_machine.helpers.startrek_helper as rm_st
import sandbox.projects.release_machine.components.components_info as rm_comp
from sandbox.projects.release_machine import client


class AfishaInfo(rm_comp.ReferenceComponent):

    @property
    def st_tags(self):
        return ["rm_main_ticket", self.name, "component_{}".format(self.name)]

    def __escalate_opened_release_issue(self, issue):
        issue.comments.create(text="Новый релиз не был сформирован, тк данный релиз открыт (не закрыта релизная задача)")

    def new_release_trigger_activated(self, *args, **kwargs):

        logging.debug("new_release_trigger_activated with args: %s, kwargs: %s", args, kwargs)
        rm_client = kwargs.pop("rm_client", client.RMClient())
        current_scope_num = int(self.last_scope_num)
        next_scope_num = current_scope_num + 1
        logging.debug("current_scope_num: %s, next: %s", current_scope_num, next_scope_num)
        # Check if new release was already created
        pre_release_button_events = rm_client.get_events(self.name, ["PreReleaseButton"], length=1).get("events", [])
        logging.debug("Got pre release button events: %s", pre_release_button_events)
        if pre_release_button_events:
            last_event_scope_num = int(json.loads(pre_release_button_events[0]["info"])["scope_number"])
        else:
            last_event_scope_num = 0
        new_release_created = last_event_scope_num >= next_scope_num
        logging.debug("new_release_created result: %s", new_release_created)

        return self.svn_cfg__allow_autobranches and not new_release_created

    def new_release_requirements_satisfied(self, *args, **kwargs):
        logging.debug("New release requirements satisfied with args: %s, kwargs: %s", args, kwargs)
        st_helper = rm_st.STHelper(rm_sec.get_rm_token(self))
        st_filter = ["Resolution: empty()",
                     "Status: !Выложили",
                     "Tags: {}".format(self.name)]
        logging.debug("Searching opened tickets by filter %s", st_filter)
        opened_release_issues = st_helper.find_tickets_by_filter(self, st_filter)
        if not opened_release_issues:
            logging.debug("No opened issues, returning True")
            return True
        logging.debug("Found opened issues: %s. Returning False", opened_release_issues)
        return False

    def get_controls(self, release_num):
        return (
            u"* тег %%skip_release_{component_name}_{release_num}%% - выключает задачу из цикла для текущего релиза\n"
            u"* тег %%component_{component_name}%% - привязывает задачу к релизу конкретного компонента(ов). "
            u"Если нет - все подвязанные релизы считаются связанными\n"
            u"* компонент %%ProdAction%% - призовет исполнителя (автора) в задачу, когда связанный релиз(ы) доедут до прода\n"
            u"((https://wiki.yandex-team.ru/alet/ops/release_cycle2/#kontroli Подробнее про контроли))"
        ).format(
            component_name=self.name,
            release_num=release_num,
        )

    def st_description(self, release_num=None):
        return (
            u"{base_descr}\n\n"
            u"=====Контроли релизного цикла для связанных задач\n{controls}\n\n"
        ).format(
            base_descr=super(AfishaInfo, self).st_description(release_num),
            controls=self.get_controls(release_num)
        )
