# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import sandbox.projects.release_machine.components.components_info as rm_comp


class AppHostInfo(rm_comp.ReferenceComponentMetricsed):
    def filter_tickets(self, changelog_entry):
        tickets_should_link = super(AppHostInfo, self).filter_tickets(changelog_entry)
        if len(tickets_should_link) == 0:
            return tickets_should_link
        for path in changelog_entry.get("revision_paths", []):
            if "apphost" in path:
                return tickets_should_link
        return set()
