# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import logging
import re
import time

import sandbox.common.types.resource as ctr
import sandbox.projects.release_machine.components.components_info as rm_comp
from sandbox import sdk2
from sandbox.projects.release_machine import rm_utils
from sandbox.projects.release_machine.core import DeployedResource


class AutoSupBsComponentInfo(rm_comp.ReferenceComponent):

    def get_last_deploy(self, token=None, only_level=None):

        try:
            resource = sdk2.Resource['SANDBOX_TASKS_BINARY'].find(
                state=ctr.State.READY,
                attrs={'name': 'autosupbs_2', 'released': 'stable'}
            ).first()

            task_id = resource.task_id
            arcadia_url = rm_utils.get_input_field(task_id, "arcadia_url")
            logging.info('arcadia_url = {}'.format(arcadia_url))
            releases = re.findall(r'stable-(\d+)-(\d+)', arcadia_url, re.UNICODE)

            major_release = int(releases[0][0])
            minor_release = int(releases[0][1])

            return [
                DeployedResource(
                    id=resource.id,
                    component=self.name,
                    timestamp=int(time.time()),
                    major_release=major_release,
                    minor_release=minor_release
                )
            ]
        except Exception:
            logging.error("Failed to get last deploy info", exc_info=True)
