# -*- encoding: utf-8 -*-
from __future__ import unicode_literals


import time

from sandbox.projects.common.conductor import Api, NoAuth
import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.release_machine.core as rm_core
import sandbox.projects.release_machine.core.const as rm_const


class BalanceInfo(rm_comp.ReferenceComponent):
    def get_last_deploy(self, token=None, only_level=rm_const.ReleaseStatus.stable):
        if only_level == rm_const.ReleaseStatus.stable:
            conductor_api = Api(task=self, auth=NoAuth())
            version = conductor_api.get_package_version_on_host("greed3v.paysys.yandex.net", "yb-balance-arcadia")
            global_version, major_num, minor_num = version.split(".")
            return [rm_core.DeployedResource(
                major_release=major_num,
                minor_release=minor_num,
                component=self.name,
                status=rm_const.ReleaseStatus.stable,
                timestamp=int(time.time()),
            )]
        else:
            return [rm_core.DeployedResource.from_released(i) for i in self.get_last_release(only_level)]
