# coding: utf-8
from __future__ import unicode_literals


from sandbox.projects.release_machine.client import RMClient

TEST_TARGETS = [
    "l7heavy_experiments_vla",
    "l7heavy_production_fukraine_man",
    "l7heavy_production_tun_man_only",
    "l7heavy_production_tun_man",
    "l7heavy_production_tun_sas_only",
    "l7heavy_production_tun_sas",
    "l7heavy_production_tun_vla_only",
    "l7heavy_production_tun_vla",
    "l7heavy_production_yaru_man",
    "l7heavy_production_yaru_sas",
    "l7heavy_production_yaru_vla",
    "l7heavy_testing_tun_man",
    "l7heavy_testing_tun_sas",
    "l7heavy_testing_tun_vla",
]


def _component_pinned_message(component_name, st_ticket_link=None, scope_number=None):
    rm_client = RMClient()
    curr_version = rm_client.get_current_version(component_name) or {}
    acceptance_ticket = ""
    db_link = ""
    if not st_ticket_link or not scope_number:
        scopes = rm_client.get_scopes(component_name=component_name, limit=1)["branchScopes"]
        if scopes:
            last_scope = scopes[0]
            st_ticket = last_scope.get('ticketKey')
            st_ticket_link = st_ticket_link or ("https://st.yandex-team.ru/{}".format(st_ticket) if st_ticket else "")
            scope_number = scope_number or last_scope.get('scopeNumber')

    # Add info about acceptance ticket if it exists in last component scope
    if st_ticket_link:
        acceptance_ticket = "Acceptance: {}\n".format(st_ticket_link)

    # Add db link if can get info about last scope
    if scope_number:
        db_link = (
            "Timeline: <a href=\"https://testenv.yandex-team.ru/?screen=timeline&"
            "database={component_name}-{scope_number}\">{component_name}-{scope_number}</a>".format(
                component_name=component_name, scope_number=scope_number,
            )
        )

    return (
        "**{component_name}**\n"
        "Production: {last_major}-{last_minor}\n"
        "{acceptance_ticket}"
        "How to deploy: https://nda.ya.ru/3UWPXP\n"
        "{db_link}"
    ).format(
        component_name=component_name,
        last_major=curr_version.get("scope_number"),
        last_minor=curr_version.get("tag_number"),
        acceptance_ticket=acceptance_ticket,
        db_link=db_link,
    )


def balancer_and_balancer_config_pin_message(
        balancer_st_ticket_link=None,
        balancer_scope_number=None,
        balancer_config_st_ticket_link=None,
        balancer_config_scope_number=None,
):
    return "{balancer_message}\n{balancer_config_message}\n\nInvite: {invite_link}".format(
        balancer_message=_component_pinned_message(
            "balancer",
            balancer_st_ticket_link,
            balancer_scope_number,
        ),
        balancer_config_message=_component_pinned_message(
            "balancer_config",
            balancer_config_st_ticket_link,
            balancer_config_scope_number,
        ),
        invite_link="https://t.me/joinchat/UWhylyxFwrSvlBlJ",
    )
