# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import logging
import re

import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.common.reactor as reactor
import sandbox.projects.common.testenv_client as rm_te
import sandbox.projects.common.requests_wrapper as req_wrapper
import sandbox.projects.common.error_handlers as eh
import sandbox.projects.common.decorators as decorators


class BaseInfo(rm_comp.ReferenceComponentMetricsed):
    _te_add_rty_db_type = ["unit", "cluster"]
    reactor_namespace = '/release-machine/search/base_web'

    __add_dbs = []

    @property
    def testenv_cfg__merge_on_clone(self):
        return []

        if not self.__add_dbs:
            rty_db_templates = [re.compile("rtyserver-[0-9.]+-{}-linux".format(i)) for i in self._te_add_rty_db_type]
            try:
                db_list_getter = "https://testenv.yandex-team.ru/handlers/grids/databasesAsList"
                db_list = [i["name"] for i in req_wrapper.get(db_list_getter, timeout=40).json()["rows"]]
                for db_template in rty_db_templates:
                    max_db = max(db_template.search(i).group(0) for i in db_list if db_template.search(i))
                    if max_db:
                        self.__add_dbs.append(max_db)
            except Exception as exc:
                eh.log_exception("Unable to get additional testenv dbs", exc)
            logging.info("Add dbs: %s", self.__add_dbs)
        return self.__add_dbs

    def _get_rty_ignored_tests(self):  # SEARCH-6798
        tests_to_ignore = set([])
        try:
            for te_db, te_db_type in zip(self.testenv_cfg__merge_on_clone, self._te_add_rty_db_type):
                flaky_jobs_info = rm_te.TEClient.get_flaky_jobs(te_db)
                jobs_info = rm_te.TEClient.get_all_jobs(te_db)
                all_light_jobs = {i["name"] for i in jobs_info if i.get("tags") == "LIGHT_PRECOMMIT_CHECKS"}
                for test_info in flaky_jobs_info:
                    if (
                        test_info["test_name"].startswith("TEST_OXYGEN_") or
                        test_info["test_name"].startswith("BUILD_") or
                        test_info["test_name"].startswith("TEST_RTYSERVER_UNIT_")
                    ):
                        continue
                    if (
                        not test_info["is_flaky"] and "." in test_info["flaky_pattern"]
                    ) and test_info["test_name"] in all_light_jobs:
                        # test is not broken and is not flaky and light
                        continue
                    tests_to_ignore.add(test_info["test_name"])
            logging.info("Tests to ignore for rty (%s): %s", len(tests_to_ignore), list(tests_to_ignore))
        except Exception as exc:
            eh.log_exception("Failed to get tests to ignore", exc)
        return list(tests_to_ignore)

    @decorators.retries(3)
    def st_post_release(self, task, auth_token, release_num=None):
        reactor.reactor_push_instance(auth_token, self.reactor_namespace, release_num)
