# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import re
import time
import logging
import requests
from collections import Counter

from sandbox import sdk2
from sandbox.projects.release_machine.core import DeployedResource
import sandbox.projects.release_machine.components.components_info as rm_comp


class BigbComponentInfo(rm_comp.ReferenceComponent):

    def get_last_deploy(self, token=None, only_level=None):
        try:
            samogon_contour = self.releases_cfg__samogon_contour_to_check

            samogon_token = sdk2.Vault.data("BSYETI", "BIGB_SAMOGON_TOKEN")

            r = requests.get(
                "http://clusterapi-{}.n.yandex-team.ru/hosts/versions".format(samogon_contour),
                headers={"Authorization": "OAuth {}".format(samogon_token)}
            )

            versions = {host: info["package"][0] for host, info in r.json()["value"].items() if len(info["package"]) > 0}

            version_counts = Counter(versions.values())

            version = max(version_counts.items(), key=lambda x: x[1])[0]
            resource_id = int(version[4:])

            logging.info("Got service versions: %s", versions)

            resource = sdk2.Resource.find(id=resource_id).first()
            m = re.search(r"stable-(?P<major>\d+)-(?P<minor>\d+)", resource.branch)

            return [
                DeployedResource(
                    id=resource_id,
                    major_release=m.group("major"),
                    minor_release=m.group("minor"),
                    component=self.name,
                    timestamp=int(time.time()),
                    build_task_id=resource.task_id,
                    owner=resource.owner
                )
            ]
        except Exception:
            logging.error("Failed to get last deploy info", exc_info=True)
