# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import logging

import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.release_machine.helpers.startrek_helper as rm_st
from sandbox.projects.common import decorators


class BoltalkaInfo(rm_comp.ReferenceComponent):

    def custom_st_update(self, st_helper, issue=None):
        transition = 'RC'
        linked_issues = st_helper.st_client.issues.find(
            query='"Linked To": {0} AND Status: Tested'.format(issue.key)
        )
        logging.debug("Collect Tested issues: %s", " ".join([str(l_issue.key) for l_issue in linked_issues]))
        for l_issue in linked_issues:
            if issue.status.key == transition:
                continue
            available_transitions = [tr.id for tr in l_issue.transitions.get_all()]
            if transition in available_transitions:
                logging.info("Execute transition '%s'.", transition)
                issue.transitions[transition].execute()

    @decorators.retries(3)
    def st_post_release(self, task, auth_token, release_num=None):
        st_helper = rm_st.STHelper(token=auth_token)
        issue = st_helper.find_ticket_by_release_number(release_num, self)
        linked_issues = st_helper.st_client.issues.find(
            query='"Linked To": {0} AND (Status: "RC" OR Status: "Tested") AND (Queue: "ASSISTANT")'.format(issue.key)
        )
        logging.debug("Collect issues: %s", " ".join([str(l_issue.key) for l_issue in linked_issues]))
        for l_issue in linked_issues:
            st_helper.close_issue(l_issue, "Close ticket, Boltalka release {} has been released".format(release_num))
