# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import sandbox.projects.release_machine.components.components_info as rm_comp


class BulbasaurInfo(rm_comp.ReferenceComponent):
    def st_description(self, release_num=None):
        checks_table = (
            '====Чеклист по релизу====\n'
            '#|\n'
            '|| **Проверка** | **Ответственный** | **ОК/НЕОК** |**Комментарий** ||\n'
            '|| Пресмоук пройден | Релиз-инженер | {is_ok} |  ||\n'  # noqa
            '|| Автоматические evo-тесты | Релиз-инженер | {is_ok} |  ||\n'  # noqa
            '|| Все новые изменения протестированы | QA-инженер | {is_ok} | ||\n '  # noqa
            '|| Ручной регресс ран пройден | QA-инженер | {is_ok} |  ||\n'  # noqa
            '|#\n'
        ).format(is_ok='!!(зел)ОК!!/!!НЕОК!!')

        release_stand_configuration = (
            '====Конфигурация стенда для тестирования====\n'
            '#|\n'
            '|| **Uniproxy URL** | wss://beta.uniproxy.alice.yandex.net/alice-uniproxy-hamster/uni.ws?srcrwr=IOT_USER_INFO:VOICE__IOT_USER_INFO_BETA ||\n'  # noqa
            '|| **Vins URL** | http://vins.hamster.alice.yandex.net/speechkit/app/pa/?srcrwr=IoT:iot-beta.quasar.yandex.net:80&srcrwr=SCENARIO_IOT_APPLY:iot-beta.quasar.yandex.net:80&srcrwr=IoTScenarios:iot-beta.quasar.yandex.net:80&srcrwr=SCENARIO_IOTSCENARIOS_APPLY:iot-beta.quasar.yandex.net:80&srcrwr=IoTVoiceDiscovery:iot-beta.quasar.yandex.net:80&srcrwr=SCENARIO_IOTVOICEDISCOVERY_APPLY:iot-beta.quasar.yandex.net:80 ||\n'  # noqa
            '|| **Ссылка на UI (iot) в браузере** | https://hamster.yandex.ru/iot?srcrwr=IOT_HOST%3Aiot-beta.quasar.yandex.ru&srcrwr=IOT__USER_INFO:SHARED__IOT_USER_INFO_BETA ||\n'  # noqa
            '|| **Ссылка на UI (quasar) в браузере** | https://hamster.yandex.ru/quasar?srcrwr=IOT_HOST%3Aiot-beta.quasar.yandex.ru&srcrwr=IOT__USER_INFO:SHARED__IOT_USER_INFO_BETA ||\n'  # noqa
            '|| **YellowSkin ПП** | %%yellowskin://?url=https%3A%2F%2Fhamster.yandex.ru%2Fquasar%3Fsrcrwr%3DIOT_HOST%3Aiot-beta.quasar.yandex.ru%26srcrwr%3DIOT__USER_INFO%3ASHARED__IOT_USER_INFO_BETA%% ||\n'  # noqa
            '|| **Yellowskin ПП QR-код** | 0x0:https://disk.yandex.net/qr/?clean=1&text=yellowskin%3A%2F%2F%3Furl%3Dhttps%253A%252F%252Fhamster.yandex.ru%252Fquasar%253Fsrcrwr%253DIOT_HOST%25253Aiot-beta.quasar.yandex.ru%2526srcrwr%253DIOT__USER_INFO%253ASHARED__IOT_USER_INFO_BETA ||\n'  # noqa
            '|| **Конфиг для колонок** | %%{"uniProxyUrl": "wss://beta.uniproxy.alice.yandex.net/alice-uniproxy-hamster/uni.ws?srcrwr=IOT_USER_INFO:VOICE__IOT_USER_INFO_BETA", "vinsUrl": "http://vins.hamster.alice.yandex.net/speechkit/app/pa/?srcrwr=IoT:iot-beta.quasar.yandex.net:80&srcrwr=SCENARIO_IOT_APPLY:iot-beta.quasar.yandex.net:80&srcrwr=IoTScenarios:iot-beta.quasar.yandex.net:80&srcrwr=SCENARIO_IOTSCENARIOS_APPLY:iot-beta.quasar.yandex.net:80&srcrwr=IoTVoiceDiscovery:iot-beta.quasar.yandex.net:80&srcrwr=SCENARIO_IOTVOICEDISCOVERY_APPLY:iot-beta.quasar.yandex.net:80"}%%  ||\n'  # noqa
            '|#\n'
        )

        release_engineer_instructions = (
            '====Памятка релиз-инженеру====\n'  # noqa
            '**До начала регресса**\n'  # noqa
            '1. Принять у предыдущего релиз-инженера релиз\n'  # noqa
            '**Во время регресса**\n'  # noqa
            '2. Помогать с найденными в релизе багами QA-инженеру\n'  # noqa
            '**После успешного окончания регресса**\n'  # noqa
            '3. Выкатить в прод все нужные компоненты\n'  # noqa
            '4. Пометить в релизной машине текущие ресурсы как продовые с помощью кнопки release и выбрав release item BULBASAUR_ALL_STABLE\n'  # noqa
            '5. Перевести релизный тикет в production после окончания выкатки\n'  # noqa
            '**В течение недели**\n'  # noqa
            '6. Мониторить изменение количества ошибок и perfomance после релиза c помощью https://solomon.yandex-team.ru/?project=alice-iot\n'  # noqa
            '**В день отведения следующего релиза**\n'  # noqa
            '7. Отвести следующий релиз в релизной машине с помощью кнопки pre-release https://rm.z.yandex-team.ru/component/bulbasaur/manage\n'  # noqa
            '8. Провести пресмоук и обеспечить передачу релиза следующему инженеру.\n'  # noqa
            '9. Перевести тикеты следующего релиза в нужные статусы для тестирования \n'  # noqa
        )

        presmoke_instructions = (
            '====Предрелизный пресмоук====\n'  # noqa
            'Все действия в UI нужно делать на https://hamster.yandex.ru/iot?srcrwr=IOT_HOST%3Aiot-beta.quasar.yandex.ru&srcrwr=IOT__USER_INFO:SHARED__IOT_USER_INFO_BETA\n'  # noqa
            '#|\n'  # noqa
            '|| № | Кейс | OK/НЕОК | Комментарии ||\n'  # noqa
            '|| 1 | Таб устройств открывается успешно | !!(зел)ОК!!/!!НЕОК!! | ||\n'  # noqa
            '|| 2 | Можно успешно управлять Яндекс лампочкой со страницы устройства  | !!(зел)ОК!!/!!НЕОК!! | ||\n'  # noqa
            '|| 3 | Список провайдеров открывается, обновление списка устройств с Xiaomi работает | !!(зел)ОК!!/!!НЕОК!! | ||\n'  # noqa
            '|| 4 | Таб сценариев открывается, можно добавлять и редактировать любые сценарии | !!(зел)ОК!!/!!НЕОК!! | ||\n'  # noqa
            '|| 5 | Можно управлять лампочкой Xiaomi голосом | !!(зел)ОК!!/!!НЕОК!! | ||\n'  # noqa
            '|| 6 | Можно запустить сценарий голосом | !!(зел)ОК!!/!!НЕОК!! | ||\n'  # noqa
            '|| 7 | Автоматические evo-тесты завершились успешно | !!(зел)ОК!!/!!НЕОК!! | ||\n'  # noqa
            '|#\n'  # noqa
        )
        return (
            '{checks_table}\n\n'
            '{release_stand_configuration}\n\n'
            '{release_engineer_instructions}\n\n'
            '{presmoke_instructions}\n\n'
        ).format(
            checks_table=checks_table,
            release_stand_configuration=release_stand_configuration,
            release_engineer_instructions=release_engineer_instructions,
            presmoke_instructions=presmoke_instructions,
        )
