# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import logging
import re

import sandbox.projects.release_machine.components.components_info as rm_comp
from sandbox.projects.release_machine import rm_utils


class ExpFormulasInfo(rm_comp.Tagged):
    def get_stable_release_label(self, release_item, release_num):
        re_tag = re.compile(r".*/tags/dynamic_ranking_models/(.*)")
        exp_url = rm_utils.get_input_or_ctx_field(release_item.build_task_id, release_item.build_ctx_key)
        logging.info("Exp url is %s", exp_url)
        exp_url_tag = re_tag.search(exp_url).group(1)

        return "{}: {}".format(release_item.name, exp_url_tag)
