# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import logging
import os

import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.release_machine.helpers.svn_helper as rm_svn


class GeoCommonInfo(rm_comp.ReferenceComponentMetricsed):
    __last_tag_num = {}

    def last_tag_num(self, branch_num):
        if branch_num not in self.__last_tag_num:
            logging.debug("Getting last tag number (images flavor)")
            branch_tag_dir = os.path.join(self.svn_cfg__tag_dir, "stable-{}".format(branch_num))
            regex = "^r([0-9]+)/"
            self.__last_tag_num[branch_num] = int(rm_svn.SvnHelper.get_highest_folder(branch_tag_dir, regex, only_num=True))
        return self.__last_tag_num[branch_num]

    def tag_wiki_page_name(self, branch_num=None, tag_num=None):
        if branch_num is None:
            branch_num = self.last_branch_num
        tag_num = tag_num or self.last_tag_num(branch_num)
        return "r{}".format(tag_num)
