# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import logging
import os

import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.release_machine.helpers.svn_helper as rm_svn
from sandbox.projects.common import decorators


class ImagesBaseInfo(rm_comp.ReferenceComponentMetricsed):
    svn_cfg__max_active_branches = 6  # equal to number of active testenv dbs
    testenv_last_good_revision_ignore_release_jobs = True

    @property
    def notify_cfg__st__assignee(self):
        return self.get_responsible_for_release()

    __last_tag_num = {}

    def last_tag_num(self, branch_num):
        if branch_num not in self.__last_tag_num:
            logging.debug("Getting last tag number (images flavor)")
            branch_tag_dir = os.path.join(self.svn_cfg__tag_dir, "stable-{}".format(branch_num))
            regex = "^r([0-9]+)/"
            self.__last_tag_num[branch_num] = int(rm_svn.SvnHelper.get_highest_folder(branch_tag_dir, regex, only_num=True))
        return self.__last_tag_num[branch_num]

    def tag_wiki_page_name(self, branch_num=None, tag_num=None):
        if branch_num is None:
            branch_num = self.last_branch_num
        tag_num = tag_num or self.last_tag_num(branch_num)
        return "r{}".format(tag_num)

    @decorators.retries(3)
    def change_ticket_on_post_deploy(self, major_release, st_helper, task):
        issue = st_helper.find_ticket_by_release_number(major_release, self)
        st_helper.close_issue(issue, "Closing ticket, because {} branch is released".format(major_release))
