# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import json
import logging

from sandbox.common import rest
from sandbox.projects.common import resource_selectors
from sandbox.projects.release_machine.components import components_info as rm_comp
from sandbox.projects.release_machine import client
from sandbox.projects.release_machine.core import const as rm_const


class ImagesRobotInfo(rm_comp.ReferenceComponentMetricsed):
    # This actually not used anymore
    def new_release_trigger_activated_old_version(self, *args, **kwargs):
        logging.debug("new_release_trigger_activated with args: %s, kwargs: %s", args, kwargs)

        rm_client = kwargs.pop("rm_client", client.RMClient())

        current_scope_num = int(self.last_scope_num)
        next_scope_num = current_scope_num + 1
        logging.debug("current_scope_num: %s, next: %s", current_scope_num, next_scope_num)

        # Detect if branch for last stable release equal to last testing release
        acceptance_branch_released = False
        sb_client = rest.Client()
        if self.releases_cfg__resources_info:
            resource_type = self.releases_cfg__resources_info[0].resource_type
            branches = []
            for release_stage in [rm_const.ReleaseStatus.stable, rm_const.ReleaseStatus.testing]:
                resource_id, _ = resource_selectors.by_last_released_task(
                    resource_type=resource_type,
                    stage=release_stage
                )
                logging.debug("for %s stage found resource_id = %s", release_stage, resource_id)
                task_id = sb_client.resource[resource_id].read()["task"]["id"]
                logging.debug("for resource_id = %s parent task_id = %s", resource_id, task_id)
                branch = sb_client.task[task_id].context.read()["testenv_database"].split('-')[-1]
                logging.debug("for task_id = %s testenv_database = %s", task_id, branch)
                branches.append(branch)

            if len(branches) == 2:
                if int(branches[0]) == int(branches[1]) and int(branches[0]) == current_scope_num:
                    acceptance_branch_released = True
                else:
                    logging.debug("branches (released: %s, %s, last_branch: %s) differs", branches[0], branches[1], current_scope_num)
            else:
                logging.debug("found branches (%s) differ from 2", len(branches))

        # Check if new release was already created
        pre_release_button_events = rm_client.get_events(self.name, ["PreReleaseButton"], length=1).get("events", [])
        logging.debug("Got pre release button events: %s", pre_release_button_events)
        if pre_release_button_events:
            last_pre_release_scope_num = int(json.loads(pre_release_button_events[0]["info"])["scope_number"])
        else:
            last_pre_release_scope_num = 0
        new_release_created = pre_release_button_events and last_pre_release_scope_num >= next_scope_num
        logging.debug("Last pre-release = %d. New release %d was %s created", last_pre_release_scope_num, next_scope_num, "already" if new_release_created else "not")

        logging.debug("acceptance_branch_released = %s   new_release_created = %s", acceptance_branch_released, new_release_created)
        activated = self.svn_cfg__allow_autobranches and acceptance_branch_released and not new_release_created
        logging.debug("will branch be created = %s", activated)

        return activated
