# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import re

import requests
import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.sdk2.vcs.svn import Arcadia


class BaseModadvertInfo(rm_comp.ReferenceComponent):

    # @property
    def st_description(self, release_num=None):
        te_db_name = self.testenv_cfg__db_template.format(testenv_db_num=release_num or self.last_branch_num)
        return (
            "TESTENV Tests: (({manage} TE {title})), (({timeline} timeline))\n"
            "Broken tests in modadvert: (({ci_link} tests list))\n"
            "Sandbox tasks related to release: "
            "((https://sandbox.yandex-team.ru/tasks?desc_re={title}&hidden=true {title}))\n"
            "Changelogs: (({changelog} major changelog))"
        ).format(
            manage=rm_const.Urls.te_db_screen(te_db_name),
            title=te_db_name,
            timeline=rm_const.Urls.te_db_screen(te_db_name, screen_name="timeline"),
            ci_link=self.get_tests_link(),
            changelog="".join([rm_const.Urls.WIKI, self.changelog_major_url(release_num)]),
        )

    def get_trunk_revision(self):
        try:
            commit_message = Arcadia.log(self.last_scope_path, self.get_revision())[0]["msg"]
            return re.match(r'.*\(r([\d]+)', commit_message).group(1)
        except Exception:
            return self.get_revision()

    def get_revision(self, release_num=None):
        if release_num:
            path = self.full_branch_path(release_num)
        else:
            path = self.last_scope_path
        return Arcadia.info(path)["commit_revision"]

    def get_tests_link(self):
        prep_request = requests.PreparedRequest()
        revision = self.get_trunk_revision()
        prep_request.prepare_url(
            "https://ci.yandex-team.ru/commit/{}/".format(revision),
            {
                "only_important_diffs": 0,
                "status": "FAILED",
                "event_id": revision,
                "test_path": "modadvert",
            }
        )
        return prep_request.url


class LyncherInfo(BaseModadvertInfo):

    def get_deploy_message(self, release_num=None):
        return (
            "(({deploy_link_arnold} Deploy to **ARNOLD**))\n"
            "(({deploy_link_hahn} Deploy to **HAHN**))\n"
            "(({deploy_link_offline} Deploy **OFFLINE** lyncher))"
        ).format(
            deploy_link_arnold=self.get_deploy_url("arnold", release_num=release_num),
            deploy_link_hahn=self.get_deploy_url("hahn", release_num=release_num),
            deploy_link_offline=self.get_deploy_url("offline", release_num=release_num),
        )

    def get_deploy_url(self, cluster, release_num=None):
        """Returns url for running _TEST__LYNCHER__DEPLOY_TO_{} test"""
        cluster = cluster.upper()
        prep_request = requests.PreparedRequest()
        prep_request.prepare_url(
            "https://testenv.yandex-team.ru/?screen=simple_run_tests",
            {
                "database": self.testenv_cfg__db_template.format(testenv_db_num=release_num or self.last_branch_num),
                "job_name": "_TEST__LYNCHER__DEPLOY_TO_{}".format(cluster),
                "revision": self.get_revision(release_num),
                "title": "Deploy Lyncher to {}".format(cluster),
                "message": "Update Lyncher scheduer with new binaries",
                "reuse_results": "true",
            }
        )
        return prep_request.url


class SupermoderationInfo(BaseModadvertInfo):

    def get_deploy_message(self, release_num=None):
        return "\n".join(
            "(({} Deploy **{}**))".format(
                self.get_deploy_url(release_stage, environment, release_num),
                environment
            ) for release_stage, environment in [
                (rm_const.ReleaseStatus.unstable, "DEV"),
                (rm_const.ReleaseStatus.prestable, "STAGE"),
                (rm_const.ReleaseStatus.testing, "TESTING"),
                (rm_const.ReleaseStatus.stable, "PROD"),
            ]
        )

    def get_deploy_url(self, release_stage, environment, release_num=None):
        """Returns url for running corresponding deployment task"""
        db_name = self.testenv_cfg__db_template.format(testenv_db_num=release_num or self.last_branch_num)
        environment = environment.upper()
        prep_request = requests.PreparedRequest()
        prep_request.prepare_url(
            "https://testenv.yandex-team.ru/?screen=simple_run_tests",
            {
                "database": db_name,
                "job_name": "_ACTION_RELEASE__SUPERMODERATION__DEPLOY_{release_stage}_{environment}".format(
                    release_stage=release_stage.upper(),
                    environment=environment.upper(),
                ),
                "revision": self.get_revision(release_num),
                "title": "Deploy Supermoderation to {}".format(environment),
                "message": "Deploy Supermoderation to {}".format(environment),
                "reuse_results": "true",
            }
        )
        return prep_request.url


class BrandsInfo(BaseModadvertInfo):

    def get_deploy_message(self, release_num=None):
        return (
            "(({deploy_dev_link} Deploy **DEVELOPMENT** environment))\n"
            "(({deploy_prod_link} Deploy **PRODUCTION** environment))"
        ).format(
            deploy_dev_link=self.get_deploy_url("dev", release_num=release_num),
            deploy_prod_link=self.get_deploy_url("prod", release_num=release_num),
        )

    def get_deploy_url(self, environment, release_num=None):
        """Returns url for running _TEST__BRANDS__DEPLOY_{} test"""
        db_name = self.testenv_cfg__db_template.format(testenv_db_num=release_num or self.last_branch_num)
        environment = environment.upper()
        prep_request = requests.PreparedRequest()
        prep_request.prepare_url(
            "https://testenv.yandex-team.ru/?screen=simple_run_tests",
            {
                "database": db_name,
                "job_name": "_TEST__BRANDS__DEPLOY_{}".format(environment),
                "revision": self.get_revision(release_num),
                "title": "Deploy Brands to {}".format(environment),
                "message": "Deploy Brands to {}".format(environment),
                "reuse_results": "true",
            }
        )
        return prep_request.url


class CupidInfo(BaseModadvertInfo):

    def get_deploy_message(self, release_num=None):
        return (
            "(({deploy_link_testing} Deploy to **TESTING**))\n"
            "(({deploy_link_stable} Deploy to **STABLE**))\n"
        ).format(
            deploy_link_testing=self.get_deploy_url("testing", release_num=release_num),
            deploy_link_stable=self.get_deploy_url("stable", release_num=release_num)
        )

    def get_deploy_url(self, environment, release_num=None):
        db_name = self.testenv_cfg__db_template.format(testenv_db_num=release_num or self.last_branch_num)
        environment = environment.upper()
        prep_request = requests.PreparedRequest()
        prep_request.prepare_url(
            "https://testenv.yandex-team.ru/?screen=simple_run_tests",
            {
                "database": db_name,
                "job_name": "_ACTION_RELEASE__CUPID__{}".format(environment),
                "revision": self.get_revision(release_num),
                "title": "Deploy Cupid to {}".format(environment),
                "message": "Deploy Cupid to {}".format(environment),
                "reuse_results": "true",
            }
        )
        return prep_request.url
