# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.release_machine.core.const as rm_const


class SavedCopyInfo(rm_comp.ReferenceComponent):

    def notify_cfg__mail__get_start_letter(self, st_issue_key, **kwargs):
        subject = '[{name}] Стабильная ветка {name}/{branch_prefix}-{branch_num} отведена от trunk@{rev}'.format(
            name=self.name,
            branch_prefix=self.svn_cfg__branch_prefix,
            branch_num=self.last_branch_num,
            rev=self.last_rev,
        )
        content = (
            '{subject}\n\n'
            'Изменения: {changelog_link}\n\n'
            'Процесс приемки проходит в тикете: {st_base_url}{st_key}\n\n'
        ).format(
            subject=subject,
            changelog_link="".join([rm_const.Urls.WIKI, self.changelog_major_url()]),
            st_base_url=rm_const.Urls.STARTREK,
            st_key=st_issue_key,
        )
        return {
            "recipients": self.notify_cfg__mail__mailing_list,
            "subject": subject,
            "body": content,
        }
