# -*- encoding: utf-8 -*-
from __future__ import unicode_literals


import logging

import sandbox.projects.abc.client as abc_client
import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.release_machine.security as rm_sec
from sandbox.projects.common import decorators


MOBILE_UAC_BACKEND_ABC_SERVICE_ID = 32978
ROLE_DEVELOPER = 8
ROLE_SCOPE_TESTING = 'testing'
ROLE_SCOPE_MANAGEMENT = 'services_management'


class UacBackendInfo(rm_comp.ReferenceComponent):
    @decorators.retries(3)
    def custom_st_update(self, st_helper, issue=None):
        transition = 'RC'
        linked_issues = st_helper.st_client.issues.find(
            query='"Linked To": {0} AND Status: "Tested"'.format(issue.key)
        )
        logging.debug("Collect Tested issues: %s", " ".join([str(l_issue.key) for l_issue in linked_issues]))
        for l_issue in linked_issues:
            if l_issue.status.key == transition:
                continue
            available_transitions = [tr.id for tr in l_issue.transitions.get_all()]
            if transition in available_transitions:
                logging.info("Execute transition '%s'.", transition)
                issue.transitions[transition].execute()

    def get_stable_release_label(self, release_item, release_num):
        if release_num:
            return super(UacBackendInfo, self).get_stable_release_label(
                release_item, release_num
            )
        else:
            return release_item.name

    @property
    def notify_cfg__st__followers(self):
        abc_api = abc_client.AbcClient(rm_sec.get_rm_token(None))

        managers = abc_api.get_people_from_service(MOBILE_UAC_BACKEND_ABC_SERVICE_ID, role_scope=ROLE_SCOPE_MANAGEMENT)
        testers = abc_api.get_people_from_service(MOBILE_UAC_BACKEND_ABC_SERVICE_ID, role_scope=ROLE_SCOPE_TESTING)
        team = abc_api.get_people_from_service(MOBILE_UAC_BACKEND_ABC_SERVICE_ID, role_id=ROLE_DEVELOPER)
        return managers + testers + team
