# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import logging

import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.release_machine.helpers.startrek_helper as rm_st
from sandbox.projects.common import decorators


class UniproxyExperimentsInfo(rm_comp.ReferenceComponent):

    def custom_st_update(self, st_helper, issue=None):
        transition = 'RC'
        linked_issues = st_helper.st_client.issues.find(
            query='"Linked To": {0} AND Status: Tested'.format(issue.key)
        )
        logging.debug("Collect Tested issues: %s", " ".join([str(l_issue.key) for l_issue in linked_issues]))
        for l_issue in linked_issues:
            if issue.status.key == transition:
                continue
            available_transitions = [tr.id for tr in l_issue.transitions.get_all()]
            if transition in available_transitions:
                logging.info("Execute transition '%s'.", transition)
                issue.transitions[transition].execute()

        custom_summary = get_custom_summary(self.name, self.svn_cfg__branch_prefix, self.last_branch_num, self.last_rev)
        issue.comments.create(
            text=custom_summary
        )

    @decorators.retries(3)
    def st_post_release(self, task, auth_token, release_num=None):
        st_helper = rm_st.STHelper(token=auth_token)
        issue = st_helper.find_ticket_by_release_number(release_num, self)
        linked_issues = st_helper.st_client.issues.find(
            query='"Linked To": {0} AND (Status: "RC" OR Status: "Tested")'.format(issue.key)
        )
        logging.debug("Collect issues: %s", " ".join([str(l_issue.key) for l_issue in linked_issues]))
        for l_issue in linked_issues:
            st_helper.close_issue(
                l_issue, "Close ticket, uniproxy experiments release {} has been released".format(release_num)
            )


def get_custom_summary(name, branch_prefix, last_branch_num, last_rev):
    subject = '[{name}] Отведена стабильная ветка {name}/{branch_prefix}-{branch_num}'.format(
        name=name,
        branch_prefix=branch_prefix,
        branch_num=last_branch_num,
    )
    addition = '\nСсылка на бранч в Аркадии: https://a.yandex-team.ru/arc/branches/uniproxy/experiments/stable-{branch_num}'.format(
        branch_num=last_branch_num,
    )
    another_addition = '\nКоммит, которым отвели ветку: https://a.yandex-team.ru/arc/commit/{rev} (по ссылке также указан коммит, по который отвели ветку)'.format(
        rev=last_rev,
    )
    subject = subject + addition + another_addition
    return subject
