from __future__ import unicode_literals


import calendar
import logging
import time

from sandbox.common import rest
import sandbox.common.types.task as ctt
import sandbox.common.types.resource as ctr

import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.release_machine.core as rm_core
import sandbox.projects.release_machine.core.const as rm_const


class UserSessionsBaseInfo(rm_comp.ReferenceComponent):
    def st_description(self, release_num=None):
        us_branch_name = self.last_branch_path
        arcanum_us_branch_name = rm_const.Urls.make_arcanum_url(us_branch_name)
        descr = "Stable branch: {}\n".format(arcanum_us_branch_name)
        descr += super(UserSessionsBaseInfo, self).st_description(release_num)
        return descr

    def get_last_deploy(self, token=None, only_level=None):
        if only_level is not None and only_level != rm_const.ReleaseStatus.stable:
            return None
        return [rm_core.DeployedResource.from_released(i) for i in self.get_last_release()]

    def get_last_release(self, stage=None):
        # type: (ctt.ReleaseStatus) -> Generator[rm_core.ReleasedResource]
        stage = stage or self.releases_cfg__default_stage
        if stage != ctt.ReleaseStatus.STABLE:
            return
        rest_client = rest.Client()
        for res_info in self.releases_cfg__resources_info:
            res_type = res_info.resource_type
            resources = rest_client.resource.read(
                type=res_type,
                state=ctr.State.READY,
                limit=10,
            )["items"]
            ctx_key = "input_parameters.{}".format(res_info.build_ctx_key)
            for res in resources:
                if res["task"]["status"] in ctt.Status.RELEASED:
                    task_info = rest_client.task[{
                        "limit": 1,
                        "id": res["task"]["id"],
                        "fields": [ctx_key],
                        "hidden": True,
                        "children": True,
                    }]["items"][0]
                    logging.info("Build task info: %s", task_info)
                    if task_info[ctx_key]:
                        major_num = self.svn_cfg__get_major_release_num(task_info[ctx_key])
                        yield rm_core.ReleasedResource(
                            id=res["id"],
                            build_task_id=res["task"]["id"],
                            major_release=major_num,
                            minor_release=0,
                            timestamp=calendar.timegm(time.strptime(res["time"]["updated"], "%Y-%m-%dT%H:%M:%S.%fZ")),
                            component=self.name,
                            status=ctt.ReleaseStatus.STABLE,
                            owner=res["owner"],
                            resource_name=res_info.resource_name,
                        )
                        break
