# -*- coding: utf-8 -*-
from __future__ import unicode_literals


import logging

import sandbox.projects.release_machine.components.components_info as rm_comp
import sandbox.projects.release_machine.helpers.startrek_helper as rm_st
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.common import decorators


class VinsInfo(rm_comp.ReferenceComponent):

    def notify_cfg__mail__get_start_letter(self, st_issue_key, **kwargs):
        subject = '[{name}] Стабильная ветка {name}/{branch_prefix}-{branch_num} отведена от trunk@{rev}'.format(
            name=self.name,
            branch_prefix=self.svn_cfg__branch_prefix,
            branch_num=self.last_branch_num,
            rev=self.last_rev,
        )
        content = (
            '{subject}\n\n'
            'Изменения: {changelog_link}\n\n'
            'Процесс приемки проходит в тикете: {st_base_url}{st_key}\n\n'
        ).format(
            subject=subject,
            changelog_link="".join([rm_const.Urls.WIKI, self.changelog_major_url()]),
            st_base_url=rm_const.Urls.STARTREK,
            st_key=st_issue_key,
        )
        return {
            "recipients": self.notify_cfg__mail__mailing_list,
            "subject": subject,
            "body": content,
        }

    @decorators.retries(3)
    def st_post_release(self, task, auth_token, release_num=None):
        st_helper = rm_st.STHelper(token=auth_token)
        issue = st_helper.find_ticket_by_release_number(release_num, self)
        linked_issues = st_helper.st_client.issues.find(
            query='"Linked To": {0} AND (Status: "RC" OR Status: "Tested") AND (Queue: "ASSISTANT" OR Queue: "MEGAMIND" OR Queue: "ALICE")'.format(issue.key)
        )
        logging.debug("Collect issues: %s", " ".join([str(l_issue.key) for l_issue in linked_issues]))
        for l_issue in linked_issues:
            st_helper.close_issue(
                l_issue, "Close ticket, MEGAMIND/VINS/BASS release {} has been released".format(release_num)
            )
