from sandbox.projects.release_machine.components.job_graph import presets as jg_preset


class JobGraph(object):
    def __init__(self, name, use_startrek=True, releasable_items=None, release_approvement_required=False):
        self._use_startrek = use_startrek
        self._release_approvement_required = release_approvement_required
        self.releasable_items = releasable_items
        self.name = name
        self.graph = self._release + self._preset(self)

    @property
    def _preset(self):
        """
            Part for preset graph generation
        """
        return jg_preset.BasePreset()

    @property
    def _release(self):
        """
            Release part of job graph for Testenv/CI with arrows and dependencies
            :return: list with jobs
        """
        return []
