import sandbox.projects.release_machine.components.job_graph.job_data as jg_data
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.core.const as rm_const


class JobTriggerNewBranch(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerNewBranch, self).__init__(
            rm_const.JobTypes.NEW_BRANCH,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerChangelog(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerChangelog, self).__init__(
            rm_const.JobTypes.CHANGELOG,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerStartrekCommon(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerStartrekCommon, self).__init__(
            rm_const.JobTypes.STARTREK,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerStartrek(JobTriggerStartrekCommon):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        parent_job_data += (jg_data.ParentDataCtx("startrek_issue", "startrek_issue"),)
        super(JobTriggerStartrek, self).__init__(
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerWiki(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerWiki, self).__init__(
            rm_const.JobTypes.WIKI,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerWikiFinal(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerWikiFinal, self).__init__(
            rm_const.JobTypes.WIKI_FINAL,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerCloneDb(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerCloneDb, self).__init__(
            rm_const.JobTypes.CLONE_DB,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerNewTag(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerNewTag, self).__init__(
            rm_const.JobTypes.NEW_TAG,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerBuild(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerBuild, self).__init__(
            rm_const.JobTypes.BUILD,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerRun(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerRun, self).__init__(
            rm_const.JobTypes.RUN,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerTestTdiAndRearr(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerTestTdiAndRearr, self).__init__(
            rm_const.JobTypes.TEST_ALL_RA2,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerBuildTrunk(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerBuildTrunk, self).__init__(
            rm_const.JobTypes.BUILD_TRUNK,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerRelease(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerRelease, self).__init__(
            rm_const.JobTypes.RELEASE,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerActionRelease(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerActionRelease, self).__init__(
            rm_const.JobTypes.ACTION_RELEASE,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerChangelogFinal(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerChangelogFinal, self).__init__(
            rm_const.JobTypes.CHANGELOG_FINAL,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerTestBranchCommon(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter="", job_type=rm_const.JobTypes.TEST):
        super(JobTriggerTestBranchCommon, self).__init__(
            job_type,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerGenerateBeta(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerGenerateBeta, self).__init__(
            rm_const.JobTypes.YAPPY_BETA,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerTestXMLSearch(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerTestXMLSearch, self).__init__(
            rm_const.JobTypes.TEST_XML_SEARCH,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerLaunchMetrics(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter="web"):
        super(JobTriggerLaunchMetrics, self).__init__(
            rm_const.JobTypes.LAUNCH_METRICS,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerTrunkWaiter(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerTrunkWaiter, self).__init__(
            rm_const.JobTypes.WAIT_TRUNK,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerMetaTest(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerMetaTest, self).__init__(
            rm_const.JobTypes.META_TEST,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerE2ETest(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter="web"):
        super(JobTriggerE2ETest, self).__init__(
            rm_const.JobTypes.TEST_E2E,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerActionRunAcceptanceBranchedTest(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerActionRunAcceptanceBranchedTest, self).__init__(
            rm_const.JobTypes.ACTION_RUN_ACCEPTANCE_BRANCHED,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerActionRunAcceptanceTest(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerActionRunAcceptanceTest, self).__init__(
            rm_const.JobTypes.ACTION_RUN_ACCEPTANCE,
            parent_job_data,
            job_name_parameter,
        )


class JobTriggerScheduleRelease(jg_arrows.JobTrigger):
    def __init__(self, parent_job_data=(), job_name_parameter=""):
        super(JobTriggerScheduleRelease, self).__init__(
            rm_const.JobTypes.SCHEDULE_RELEASE,
            parent_job_data,
            job_name_parameter,
        )
