from sandbox.projects.release_machine.components.job_graph.presets import SinglePreset
from sandbox.projects.release_machine.components.job_graph.stages import release_stage as jg_release
from sandbox.projects.release_machine.components.job_graph.stages import build_stage as jg_build
from sandbox.projects.release_machine.components.job_graph import job_triggers as jg_triggers
from sandbox.projects.release_machine.components.job_graph import utils as jg_utils
from sandbox.projects.release_machine.core import const as rm_const


class _SingleReleaseCiPreset(SinglePreset):

    def _get_job_params(self, stage):
        job_params = dict(stage.frequency_type.get_freq_params(), ctx=self._release_ctx)
        return job_params

    def _get_job_arrows(self, stage, job_graph_instance):

        job_arrows = jg_triggers.JobTriggerBuild(
            parent_job_data=self.get_component_resources_data(job_graph_instance.releasable_items),
        )

        if not self._release_job_arrows_dict or stage.release_stage not in self._release_job_arrows_dict:
            return job_arrows

        release_job_arrows = self._release_job_arrows_dict[stage.release_stage]

        return jg_utils.tuplify(job_arrows) + jg_utils.tuplify(release_job_arrows)

    def release_job(self, stage, job_graph_instance):
        return jg_release.JobGraphElementReleaseCI(
            task_name=self._release_task_name,
            release_to=stage.release_stage,
            job_params=self._get_job_params(stage),
            job_arrows=self._get_job_arrows(stage, job_graph_instance),
        )


class SingleBuildCiPreset(_SingleReleaseCiPreset):
    def __init__(
        self,
        build_task_name="KOSHER_YA_MAKE",
        build_ctx=None,
        build_apiargs=None,
        release_task_name="RELEASE_RM_COMPONENT_2",
        deploy_system=rm_const.DeploySystem.ya_deploy.name,
        release_ctx=None,
        stages=None,
        build_frequency=jg_utils.CheckEachCommit(),
        release_job_arrows_dict=None,  # a dict of stage => job_arrows for release job - additional arrows per stage
    ):
        super(SingleBuildCiPreset, self).__init__(
            build_task_name=build_task_name,
            build_ctx=build_ctx,
            build_apiargs=build_apiargs,
            release_task_name=release_task_name,
            deploy_system=deploy_system,
            release_ctx=release_ctx,
            stages=stages,
            build_frequency=build_frequency,
            release_job_arrows_dict=release_job_arrows_dict,
        )

    def build_job(self, job_graph_instance):
        job_params = dict(self._build_frequency.get_freq_params(), apiargs=self._build_apiargs)
        return jg_build.JobGraphElementYaMakeBuildBranched(
            task_name=self._build_task_name,
            job_params=job_params,
            ctx=self._build_ctx,
            out=self._output_resources(job_graph_instance),
        )


class SingleBuildPackageCiPreset(_SingleReleaseCiPreset):
    def __init__(
        self,
        resource_names,
        build_task_name="KOSHER_YA_PACKAGE",
        build_ctx=None,
        build_apiargs=None,
        release_task_name="RELEASE_RM_COMPONENT_2",
        deploy_system=rm_const.DeploySystem.ya_deploy.name,
        package_names=None,
        release_ctx=None,
        stages=None,
        build_frequency=jg_utils.CheckEachCommit(),
        use_compression=True,
    ):
        super(SingleBuildPackageCiPreset, self).__init__(
            build_task_name=build_task_name,
            build_ctx=build_ctx,
            build_apiargs=build_apiargs,
            release_task_name=release_task_name,
            deploy_system=deploy_system,
            release_ctx=release_ctx,
            stages=stages,
            build_frequency=build_frequency,
        )

        self._resource_names = resource_names
        self._package_names = package_names
        self._use_compression = use_compression

    def build_job(self, job_graph_instance):
        job_params = dict(self._build_frequency.get_freq_params(), apiargs=self._build_apiargs)
        return jg_build.JobGraphElementBuildPackageBranched(
            resource_names=self._resource_names,
            package_names=self._package_names,
            task_name=self._build_task_name,
            job_params=job_params,
            ctx=self._build_ctx,
            out=self._output_resources(job_graph_instance),
            use_compression=self._use_compression,
        )
