from sandbox.projects.common.constants import constants as common_const
import sandbox.projects.release_machine.components.job_graph.stages.job_graph_element as jg_element
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.core.const as rm_const


class JobGraphElementBuildBase(jg_element.JobGraphElement):
    def __init__(
        self,
        task_name,
        job_params=None,
        job_arrows=(),
        build_item="",
        ctx=None,
        out=None,
        filter_targets=None,
    ):
        merged_job_params = jg_utils.merge_job_params(
            job_params,
            {
                "job_type": rm_const.JobTypes.BUILD,
                "task_name": task_name,
                "ctx": ctx,
                "out": out,
                "filter_targets": filter_targets,
                "job_name_parameter": build_item,
                "apiargs": {"hidden": False, "requirements": {"platform": "linux"}},
            },
        )
        super(JobGraphElementBuildBase, self).__init__(
            job_params=merged_job_params,
            job_arrows=job_arrows,
        )
        self.job_arrows += (
            jg_job_triggers.JobTriggerNewTag(
                parent_job_data=[
                    jg_job_data.ParentDataOutput(
                        input_key=common_const.ARCADIA_URL_KEY,
                        output_key=common_const.ARCADIA_URL_KEY,
                    ),
                ],
            ),
        )


class JobGraphElementBuildBranched(JobGraphElementBuildBase):
    def __init__(
        self,
        task_name,
        job_params=None,
        job_arrows=(),
        build_item="",
        ctx=None,
        out=None,
        filter_targets=None,
    ):
        merged_job_params = jg_utils.merge_job_params(
            job_params,
            {
                "should_add_to_db": jg_utils.should_add_to_db_branch,
                "cancel_fallbehind_runs_on_fix": False,
                "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
            },
        )
        super(JobGraphElementBuildBranched, self).__init__(
            task_name=task_name,
            job_params=merged_job_params,
            job_arrows=job_arrows,
            build_item=build_item,
            ctx=ctx,
            out=out,
            filter_targets=filter_targets,
        )
        self.job_arrows += (
            jg_arrows.ParamsData("release_number", jg_utils.get_major_release_number),  # todo: use scope_number
        )


class JobGraphElementBuildTagged(JobGraphElementBuildBase):
    def __init__(
        self,
        task_name,
        job_params=None,
        job_arrows=(),
        build_item="",
        ctx=None,
        out=None,
        filter_targets=None,
    ):
        merged_job_params = jg_utils.merge_job_params(
            job_params,
            {
                "should_add_to_db": jg_utils.should_add_to_db_trunk,
                "frequency": (jg_utils.TestFrequency.LAZY, None),
            },
        )
        default_ctx = {
            common_const.BUILD_SYSTEM_KEY: common_const.SEMI_DISTBUILD_BUILD_SYSTEM,
            common_const.ALLOW_AAPI_FALLBACK: True,
            common_const.USE_AAPI_FUSE: True,
            common_const.USE_ARC_INSTEAD_OF_AAPI: True,
        }
        if ctx:
            default_ctx.update(ctx)
        super(JobGraphElementBuildTagged, self).__init__(
            task_name=task_name,
            job_params=merged_job_params,
            job_arrows=job_arrows,
            build_item=build_item,
            ctx=ctx,
            out=out,
            filter_targets=filter_targets,
        )
        self.job_arrows += (
            jg_job_triggers.JobTriggerNewTag([
                jg_job_data.ParentDataCtx("release_number", "scope_number"),
            ]),
        )


class JobGraphElementBuildTrunk(jg_element.JobGraphElement):
    def __init__(
        self,
        task_name,
        job_params=None,
        job_arrows=(),
        build_item="",
        ctx=None,
        out=None,
        filter_targets=None,
        add_arcadia_to_arcadia_url_value=True,
    ):
        merged_job_params = jg_utils.merge_job_params(
            job_params,
            {
                "job_type": rm_const.JobTypes.BUILD,
                "task_name": task_name,
                "ctx": ctx,
                "out": out,
                "filter_targets": filter_targets,
                "job_name_parameter": build_item,
                "should_add_to_db": jg_utils.should_add_to_db_trunk,
                "frequency": (jg_utils.TestFrequency.LAZY, None),
                "apiargs": {"hidden": False, "requirements": {"platform": "linux"}},
            },
        )
        super(JobGraphElementBuildTrunk, self).__init__(
            job_params=merged_job_params,
            job_arrows=job_arrows,
        )

        if add_arcadia_to_arcadia_url_value:
            transform = lambda x, rm_config: "{svn_ssh_url}/arcadia@{revision}".format(
                svn_ssh_url=x.svn_ssh_url,
                revision=x.revision,
            )
        else:
            transform = lambda x, rm_config: "{svn_ssh_url}@{revision}".format(
                svn_ssh_url=x.svn_ssh_url,
                revision=x.revision,
            )

        self.job_arrows += (
            jg_arrows.ParamsData(
                input_key=common_const.ARCADIA_URL_KEY,
                transform=transform,
            ),
        )


class JobGraphElementYaMakeBuildBranched(JobGraphElementBuildBranched):
    def __init__(
        self,
        task_name="KOSHER_YA_MAKE",
        job_params=None,
        job_arrows=(),
        build_item="",
        ctx=None,
        out=None,
        filter_targets=None,
    ):
        default_ctx = {
            common_const.BUILD_SYSTEM_KEY: common_const.SEMI_DISTBUILD_BUILD_SYSTEM,
            common_const.ALLOW_AAPI_FALLBACK: True,
            common_const.USE_AAPI_FUSE: True,
            common_const.USE_ARC_INSTEAD_OF_AAPI: True,
        }
        if ctx:
            default_ctx.update(ctx)

        super(JobGraphElementYaMakeBuildBranched, self).__init__(
            task_name=task_name,
            job_params=job_params,
            job_arrows=job_arrows,
            build_item=build_item,
            ctx=default_ctx,
            out=out,
            filter_targets=filter_targets,
        )


class JobGraphElementYaMakeBuildTagged(JobGraphElementBuildTagged):
    def __init__(
        self,
        task_name="KOSHER_YA_MAKE",
        job_params=None,
        job_arrows=(),
        build_item="",
        ctx=None,
        out=None,
        filter_targets=None,
    ):
        default_ctx = {
            common_const.BUILD_SYSTEM_KEY: common_const.SEMI_DISTBUILD_BUILD_SYSTEM,
            common_const.ALLOW_AAPI_FALLBACK: True,
            common_const.USE_AAPI_FUSE: True,
            common_const.USE_ARC_INSTEAD_OF_AAPI: True,
        }
        if ctx:
            default_ctx.update(ctx)

        super(JobGraphElementYaMakeBuildTagged, self).__init__(
            task_name=task_name,
            job_params=job_params,
            job_arrows=job_arrows,
            build_item=build_item,
            ctx=default_ctx,
            out=out,
            filter_targets=filter_targets,
        )


class JobGraphElementBuildPackageBranched(JobGraphElementBuildBranched):
    def __init__(
        self,
        resource_names,
        task_name="YA_PACKAGE",
        job_params=None,
        job_arrows=(),
        ctx=None,
        out=None,
        filter_targets=None,
        package_names=None,
        use_compression=True,
    ):
        default_ctx = {
            common_const.CLEAR_BUILD_KEY: False,
            common_const.BUILD_SYSTEM_KEY: common_const.YMAKE_BUILD_SYSTEM,
            common_const.ALLOW_AAPI_FALLBACK: True,
            common_const.USE_AAPI_FUSE: True,
            common_const.USE_ARC_INSTEAD_OF_AAPI: True,
            "packages": package_names,
            "resource_type": resource_names,
            "package_type": "tarball",
            "publish_package": False,
            "compress_package_archive": use_compression,
        }
        if ctx:
            default_ctx.update(ctx)

        super(JobGraphElementBuildPackageBranched, self).__init__(
            task_name=task_name,
            job_params=job_params,
            job_arrows=job_arrows,
            ctx=default_ctx,
            out=out,
            filter_targets=filter_targets,
        )


class JobGraphElementBuildPackageTrunk(JobGraphElementBuildTrunk):
    def __init__(
            self,
            resource_names,
            task_name="YA_PACKAGE",
            job_params=None,
            job_arrows=(),
            ctx=None,
            out=None,
            filter_targets=None,
            package_names=None,
            use_compression=True,
    ):
        default_ctx = {
            common_const.CLEAR_BUILD_KEY: False,
            common_const.BUILD_SYSTEM_KEY: common_const.YMAKE_BUILD_SYSTEM,
            common_const.ALLOW_AAPI_FALLBACK: True,
            common_const.USE_AAPI_FUSE: True,
            common_const.USE_ARC_INSTEAD_OF_AAPI: True,
            "packages": package_names,
            "resource_type": resource_names,
            "package_type": "tarball",
            "publish_package": False,
            "compress_package_archive": use_compression,
        }
        if ctx:
            default_ctx.update(ctx)

        super(JobGraphElementBuildPackageTrunk, self).__init__(
            task_name=task_name,
            job_params=job_params,
            job_arrows=job_arrows,
            ctx=default_ctx,
            out=out,
            filter_targets=filter_targets,
        )
