import sandbox.projects.release_machine.components.job_graph.stages.job_graph_element as jg_element
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test_stage
import sandbox.projects.release_machine.components.job_graph.job_data as jg_data
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.core.const as rm_const


class JobGraphElementNewTagCI(jg_element.JobGraphElementTasklet):
    def __init__(self):
        super(JobGraphElementNewTagCI, self).__init__(
            job_params={self.JOB_TYPE_KEY: rm_const.JobTypes.NEW_TAG},
        )

    task_ci_registry_location = "projects/release_machine/create_arc_tag"


class JobGraphElementStartrekCI(jg_element.JobGraphElementTasklet):
    def __init__(self, job_arrows=(), ctx=None):
        super(JobGraphElementStartrekCI, self).__init__(
            job_params={
                self.JOB_TYPE_KEY: rm_const.JobTypes.STARTREK,
                "ctx": ctx,
            },
            job_arrows=job_arrows,
        )

    task_ci_registry_location = "projects/release_machine/get_or_create_st_ticket"


class JobGraphElementLinkStartrekTicketsCI(jg_element.JobGraphElementTasklet):
    def __init__(self, job_arrows=(), ctx=None):
        super(JobGraphElementLinkStartrekTicketsCI, self).__init__(
            job_params={
                self.JOB_TYPE_KEY: rm_const.JobTypes.LINK_STARTREK_TICKETS,
                "ctx": ctx,
            },
            job_arrows=job_arrows,
        )

        self.job_arrows += (
            jg_triggers.JobTriggerChangelogFinal([
                jg_data.TaskletDataOutput(
                    "changelog_resource",
                    "resources[?type == 'RELEASE_MACHINE_CHANGELOG'] | single(@)"
                ),
            ]),
            jg_triggers.JobTriggerStartrekCommon([
                jg_data.TaskletDataOutput("ticket_key", "st_ticket.key"),
            ]),
        )

    task_ci_registry_location = "projects/release_machine/link_feature_tickets_from_changelog"


class JobGraphElementChangelogCI(jg_element.JobGraphElement):
    def __init__(self, job_arrows=(), ctx=None):
        default_ctx = {
            "major_release_num": "${context.version_info.major}",
            "minor_release_num": "${not_null(context.version_info.minor, `0`)}",
        }
        if ctx:
            default_ctx.update(ctx)
        super(JobGraphElementChangelogCI, self).__init__(
            job_params={
                self.JOB_TYPE_KEY: rm_const.JobTypes.CHANGELOG_FINAL,
                "ctx": default_ctx,
            },
            job_arrows=job_arrows,
        )
        self.job_arrows += (
            jg_triggers.JobTriggerNewTag(jg_data.TaskletDataOutput("candidate_path", "svn_data.svn_paths.tag")),
        )

    task_ci_registry_location = "projects/release_machine/release_machine_changelog"


class JobGraphElementChangelogFormatCI(jg_element.JobGraphElementTasklet):
    def __init__(self, job_arrows=(), ctx=None):
        super(JobGraphElementChangelogFormatCI, self).__init__(
            job_params={
                self.JOB_TYPE_KEY: rm_const.JobTypes.CHANGELOG_FORMAT,
                "ctx": ctx,
            },
            job_arrows=job_arrows,
        )
        self.job_arrows += (
            jg_triggers.JobTriggerChangelogFinal([
                jg_data.TaskletDataOutput(
                    "changelog_resource",
                    "resources[?type == 'RELEASE_MACHINE_CHANGELOG'] | single(@)"
                ),
            ]),
        )

    task_ci_registry_location = "projects/release_machine/format_rm_changelog"


class JobGraphElementPostChangelogToStartrekCI(jg_element.JobGraphElement):
    def __init__(self, job_arrows=(), ctx=None):
        default_ctx = {
            "comment_marker": rm_const.CHANGELOG_MARKER,
            "place_comment": "ticket_description",
        }
        if ctx:
            default_ctx.update(ctx)
        super(JobGraphElementPostChangelogToStartrekCI, self).__init__(
            job_params={
                self.JOB_TYPE_KEY: rm_const.JobTypes.CHANGELOG_POST_ST,
                "ctx": default_ctx,
            },
            job_arrows=job_arrows,
        )
        self.job_arrows += (
            jg_arrows.JobTrigger(
                rm_const.JobTypes.STARTREK,
                jg_data.TaskletDataOutput("issue_key", "st_ticket.key")
            ),
            jg_arrows.JobTrigger(
                rm_const.JobTypes.CHANGELOG_FORMAT,
                jg_data.TaskletDataOutput("comment_text", "formatted_changelog.wiki")
            ),
        )

    task_ci_registry_location = "projects/release_machine/post_startrek_comment"


class JobGraphElementStartrekOkApprovementCI(jg_element.JobGraphElement):
    """
    https://wiki.yandex-team.ru/releasemachine/blokirovka-relizov/#blokirovkadook-ovotzadannyxsotrudnikov
    """

    def __init__(self, job_arrows=(), ctx=None):
        default_ctx = {
            "major_release_num": "${context.version_info.major}",
            "minor_release_num": "${not_null(context.version_info.minor, `0`)}",
        }

        if ctx:
            default_ctx.update(ctx)

        super(JobGraphElementStartrekOkApprovementCI, self).__init__(
            job_params={
                self.JOB_TYPE_KEY: rm_const.JobTypes.STARTREK_OK_APPROVEMENT,
                "ctx": default_ctx,
            },
            job_arrows=job_arrows,
        )

        self.job_arrows += (
            jg_triggers.JobTriggerNewTag(),
        )

    task_ci_registry_location = "projects/release_machine/create_startrek_ok_approvement"


class JobGraphElementLaunchMetricsCI(jg_test_stage.JobGraphElementLaunchMetrics):

    task_ci_registry_location = "projects/release_machine/launch_metrics"

    def __init__(
        self,
        search_subtype="web",
        job_params=None,
        job_arrows=(),
        job_name_parameter="",
        ctx=None,
        manual=False,
    ):

        ctx = ctx or {}
        job_params = job_params or {}

        if "release_num" not in ctx:
            ctx["release_num"] = "${context.version_info.major}"

        if manual:
            job_params["frequency"] = (jg_utils.TestFrequency.LAZY, None)
        else:
            job_params["frequency"] = (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)

        merged_job_params = self._prepare_job_params(search_subtype, job_params, job_name_parameter, ctx)

        super(JobGraphElementLaunchMetricsCI, self).__init__(
            job_params=merged_job_params,
            job_arrows=job_arrows,
        )
