import sandbox.projects.release_machine.components.job_graph.stages.job_graph_element as jg_element
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.core.const as rm_const


class JobGraphElementRunCommon(jg_element.JobGraphElement):
    def __init__(self, task_name, job_params=None, job_arrows=(), ctx=None, out=None, platform="any"):
        merged_job_params = jg_utils.merge_job_params(
            job_params,
            {
                "job_type": rm_const.JobTypes.RUN,
                "task_name": task_name,
                "ctx": ctx,
                "out": out,
                "apiargs": {"requirements": {"platform": platform}},
            },
        )
        super(JobGraphElementRunCommon, self).__init__(
            job_params=merged_job_params,
            job_arrows=job_arrows,
        )


class JobGraphElementRunBranchCommon(JobGraphElementRunCommon):
    def __init__(self, task_name, job_params=None, job_arrows=(), ctx=None, out=None, platform="any"):
        merged_job_params = jg_utils.merge_job_params(
            job_params,
            {
                "should_add_to_db": jg_utils.should_add_to_db_branch,
                "cancel_fallbehind_runs_on_fix": False,
            },
        )
        super(JobGraphElementRunBranchCommon, self).__init__(
            task_name=task_name,
            job_params=merged_job_params,
            job_arrows=job_arrows,
            ctx=ctx,
            out=out,
            platform=platform,
        )


class JobGraphElementRunTagCommon(JobGraphElementRunCommon):
    def __init__(self, task_name, job_params=None, job_arrows=(), ctx=None, out=None, platform="any"):
        merged_job_params = jg_utils.merge_job_params(
            job_params,
            {
                "should_add_to_db": jg_utils.should_add_to_db_trunk,
            },
        )
        super(JobGraphElementRunTagCommon, self).__init__(
            task_name=task_name,
            job_params=merged_job_params,
            job_arrows=job_arrows,
            ctx=ctx,
            out=out,
            platform=platform,
        )


JobGraphElementRunTrunkCommon = JobGraphElementRunTagCommon
