from sandbox.projects.common.constants import constants as sb_constants
from sandbox.projects.release_machine.core import releasable_items


def test__releasable_items_list_creation():
    # deploy infos
    nanny_services = (
        releasable_items.DeployService("my_nanny_service1"),
        releasable_items.DeployService("my_nanny_service2"),
    )
    nanny_dashboards = ("my_nanny_dashboard",)
    qloud_services = (releasable_items.DeployService("my_qloud_service"),)
    ya_deploy_services = (releasable_items.DeployService("my_ya_deploy_service"),)
    deploy_infos = [
        releasable_items.NannyDeployInfo(
            services=list(nanny_services),
            dashboards=nanny_dashboards,
        ),
        releasable_items.QloudDeployInfo(services=qloud_services),
        releasable_items.YaDeployInfo(services=ya_deploy_services),
    ]
    assert deploy_infos[0].dashboards == nanny_dashboards
    assert deploy_infos[0].services == nanny_services
    assert deploy_infos[1].services == qloud_services
    assert deploy_infos[2].services == ya_deploy_services
    for i in deploy_infos:
        assert i.stage == "stable"

    # data
    resource_type = "MY_SHINY_RESOURCE"
    sb_data = releasable_items.SandboxResourceData(resource_type)
    assert sb_data.resource_type == resource_type
    assert sb_data.build_ctx_key == sb_constants.ARCADIA_URL_KEY
    assert sb_data.attributes is None
    assert sb_data.dst_path is None
    assert sb_data.disc_type is releasable_items.DiskType.HDD

    # item
    item_name = "my_item"
    item1 = releasable_items.ReleasableItem(item_name, sb_data)
    assert item1.name == item_name
    assert item1.deploy_infos is None
    releasable_items.ReleasableItem(item_name, sb_data, deploy_infos=deploy_infos)
