from sandbox.common.types import client as ctc
from sandbox.sdk2 import environments as sb_sdk_env
from sandbox.projects.common import task_env as common_task_env


class TaskRequirements:
    startrek_client = sb_sdk_env.PipEnvironment("startrek_client", version="2.5.0", use_wheel=True)


class TaskTags:
    """Deprecated. For SDK1 tasks only. Use *Requirements instead."""
    all_rm = ctc.Tag.GENERIC | ctc.Tag.MULTISLOT
    startrek_client = ~ctc.Tag.LINUX_LUCID


class TinyRequirements(common_task_env.TinyRequirements):
    ram = 512  # 512 Mb


class StartrekRequirements(TinyRequirements):
    environments = [TaskRequirements.startrek_client]
