# -*- coding: utf-8 -*-

"""
    !!! DEPRECATED !!!

    Please, use projects/release_machine/changelogs/__init__.py

    Maintainers: mvel@
"""
from __future__ import unicode_literals


import six

from sandbox.projects.common import link_builder as lb
from sandbox.projects.common.testenv_client import TEClient


UNRESOLVED = "!!There are unresolved problems!!\n"


class ChangeLogFormatter(object):
    COMPONENT = "component"
    TYPE = "changelog_type"
    RELEASE_ID = "release_id"
    FIRST_REV = "first_revision"
    LAST_REV = "last_revision"
    CHANGES = "changes"
    WARNINGS = "warnings"
    RELEASE_ITEMS = "release_items"  # RMDEV-596

    startrek_header = [
        "Revision, Review",
        "Commit author",
        "Summary",
        "Tickets",
    ]
    startrek_header_grouped_by_ticket = [
        "",
        "Revision, Review",
        "Commit author",
        "Summary",
    ]
    wiki_header = startrek_header + [
        "TestEnv diffs (problems)",
        "Commit importance",
    ]

    @classmethod
    def revision_and_review(cls, c_info, entry):
        wiki_link = lb.LinkType.wiki
        revision = entry["revision"]
        revision_and_review = [
            lb.revision_link(revision, link_type=lb.LinkType.wiki)
        ]
        if entry.get("review_id"):
            revision_and_review.append(lb.review_link(
                entry["review_id"], link_name="REVIEW: {}".format(entry["review_id"]), link_type=wiki_link
            ))
        elif entry.get("review_ids"):
            for review_id in entry["review_ids"]:
                revision_and_review.append(
                    lb.review_link(review_id, link_name="REVIEW: {}".format(review_id), link_type=wiki_link)
                )
        return "\n".join(revision_and_review)

    @classmethod
    def startrek_row(cls, c_info, entry, escape_ticket=False):
        tickets = entry["startrek_tickets"]
        if escape_ticket:
            tickets = ["%%{}%%".format(ticket) for ticket in tickets]

        return [
            cls.revision_and_review(c_info, entry),
            "staff:{}".format(entry["commit_author"]),
            entry["summary"].replace("|", "/"),
            "\n".join(tickets)
        ]

    @classmethod
    def startrek_row_grouped_by_ticket(cls, c_info, entry):
        return [
            "",
            cls.revision_and_review(c_info, entry),
            "staff:{}".format(entry["commit_author"]),
            entry["summary"].replace("|", "/"),
        ]

    @classmethod
    def wiki_row(cls, c_info, entry):
        return cls.startrek_row(c_info, entry) + [
            cls.problems_str(c_info, entry["te_problems"]),
            "\u2605" * (entry["commit_importance"] + 1)  # measure importance in stars
        ]

    @staticmethod
    def problems_str(c_info, problems):
        if not problems:
            return ""
        result = []
        unresolved_mark = ""

        for comment, problem_info in six.iteritems(problems):
            links = []
            for p in problem_info:
                link = TEClient.te_diff_screen(c_info.testenv_cfg__trunk_db, p["te_diff_id"])
                if not p["resolved"]:
                    link = "??{}??".format(link)
                    if not unresolved_mark:
                        unresolved_mark = UNRESOLVED
                links.append(link)
            result.append("{}: {}".format(comment, ", ".join(links)))
        return unresolved_mark + "\n".join(result)
