from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.helpers.deploy.ab_releaser import AbReleaser
from sandbox.projects.release_machine.helpers.deploy.nanny_push_releaser import NannyPushReleaser
from sandbox.projects.release_machine.helpers.deploy.nanny_releaser import (
    NannySimpleReleaser,
    NannyReleaser,
    NannyReleaseWatcher,
)
from sandbox.projects.release_machine.helpers.deploy.qloud_releaser import QloudReleaser, QloudReleaseWatcher
from sandbox.projects.release_machine.helpers.deploy.samogon_simple_releaser import (
    SamogonSimpleReleaser,
    SamogonReleaser,
    SamogonReleaseWatcher,
)
from sandbox.projects.release_machine.helpers.deploy.sandbox_releaser import (
    SandboxSimpleReleaser,
    SandboxReleaser,
    SandboxReleaseWatcher,
)
from sandbox.projects.release_machine.helpers.deploy.ya_deploy_releaser import (
    YaDeploySimpleReleaser,
    YaDeployReleaser,
    YaDeployReleaseWatcher,
)
from sandbox.projects.release_machine.helpers.deploy.ya_tool_releaser import YaToolReleaser, YaToolReleaseWatcher
from sandbox.projects.release_machine.helpers.deploy.kosher_sandbox_releaser import (
    KosherSandboxReleaser,
    KosherSandboxReleaseWatcher,
)

DEPLOY_SYSTEM = {
    rm_const.DeploySystem.ab.name: AbReleaser,
    rm_const.DeploySystem.nanny.name: NannyReleaser,
    rm_const.DeploySystem.nanny_push.name: NannyPushReleaser,
    rm_const.DeploySystem.sandbox.name: SandboxReleaser,
    rm_const.DeploySystem.ya_tool.name: YaToolReleaser,
    rm_const.DeploySystem.qloud.name: QloudReleaser,
    rm_const.DeploySystem.z2.name: None,
    rm_const.DeploySystem.samogon.name: SamogonReleaser,
    rm_const.DeploySystem.ya_deploy.name: YaDeployReleaser,
    rm_const.DeploySystem.kosher_sandbox_release.name: KosherSandboxReleaser,
    rm_const.DeploySystem.others.name: None,
}

DEPLOY_SYSTEM_NO_SB = {
    rm_const.DeploySystem.samogon.name: SamogonSimpleReleaser,
    rm_const.DeploySystem.sandbox.name: SandboxSimpleReleaser,
    rm_const.DeploySystem.ya_deploy.name: YaDeploySimpleReleaser,
    rm_const.DeploySystem.nanny.name: NannySimpleReleaser,
}

DEPLOY_WATCHER = {
    rm_const.DeploySystem.sandbox.name: SandboxReleaseWatcher,
    rm_const.DeploySystem.ya_tool.name: YaToolReleaseWatcher,
    rm_const.DeploySystem.qloud.name: QloudReleaseWatcher,
    rm_const.DeploySystem.nanny.name: NannyReleaseWatcher,
    rm_const.DeploySystem.nanny_push.name: NannyReleaseWatcher,
    rm_const.DeploySystem.ya_deploy.name: YaDeployReleaseWatcher,
    rm_const.DeploySystem.kosher_sandbox_release.name: KosherSandboxReleaseWatcher,
}

DEPLOY_WATCHER_NO_SB = {
    rm_const.DeploySystem.samogon.name: SamogonReleaseWatcher,
}
