import json
import logging

from sandbox.projects.release_machine.core import (
    Ok,
    Error,
)
from sandbox.projects.release_machine.helpers import ab_helper
from sandbox.projects.release_machine.helpers import startrek_helper as rm_st
from sandbox.projects.release_machine.helpers.deploy import basic_releaser
from sandbox.projects.release_machine import security as rm_sec


LOGGER = logging.getLogger(__name__)


class AbReleaser(basic_releaser.SbReleaserMixin, basic_releaser.BasicReleaser):
    def do_release(self):
        ab_api = ab_helper.ABApi(rm_sec.get_rm_token(self._task, "ab_formulas_release_token"), test=True)
        data = json.loads(self._task.Parameters.data_for_testid)
        try:
            ab_api.deploy_test_id(data)
            return [Ok()]
        except Exception as e:
            return [Error("Release failed with unknown error: {}".format(e))]

    def after_release(self, release_results):
        super(AbReleaser, self).after_release(release_results)
        if all(i.ok for i in release_results):
            st_helper = rm_st.STHelper(rm_sec.get_rm_token(self))
            st_helper.comment(
                self._task.Parameters.major_release_num,
                "Test id '{}' was deployed to production".format(self._task.Parameters.data_for_testid),
                self._c_info,
            )
