# -*- coding: utf-8 -*-
from __future__ import print_function, unicode_literals

# import pytest
import mock
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.helpers.deploy import ya_tool_releaser as ytr


blame_mock = mock.Mock(return_value="\n".join([
    "6372291    dkvasov 2020-02-14 11:11:19 +0300 (Пт, 14 фев 2020) 123",
    "5215669    dkvasov 2019-07-05 19:18:44 +0300 (Пт, 05 июл 2019) 321",
    "5215670    dkvasov 2019-07-05 19:18:45 +0300 (Пт, 05 июл 2019) 333",
]))
sdk2_resource_mock = mock.MagicMock()
sdk2_resource_mock.__getitem__ = mock.Mock(return_value=mock.Mock(id=333))
json_load_mock = mock.Mock(return_value={"a": {"b": 321}})


def test__get_deploy_timestamp():
    from sandbox.sdk2.vcs.svn import Arcadia
    with mock.patch.object(Arcadia, "blame", blame_mock):
        assert ytr.get_deploy_timestamp(None, "321") == 1562343524.0


@mock.patch("sandbox.sdk2.Resource", sdk2_resource_mock)
def test__get_last_deploy_proto():
    from sandbox import sdk2
    with mock.patch.object(sdk2.vcs.svn.Arcadia, "blame", blame_mock):
        with mock.patch.object(sdk2.vcs.svn.Arcadia, "export", mock.Mock()):
            with mock.patch("sandbox.projects.common.file_utils.json_load", json_load_mock):
                watcher = ytr.YaToolReleaseWatcher(mock.Mock(), mock.Mock())
                watcher._get_revision = mock.Mock(return_value=("arc_hash", 98776551))
                watcher._get_ya_conf = mock.Mock(return_value={
                    "bottles": {
                        "mylovelyservice": {
                            "formula": {"sandbox_id": 333}
                        }
                    }
                })
                watcher._sb_rest_client = mock.MagicMock()
                watcher._sb_rest_client.task.__getitem__ = mock.Mock()
                watcher._sb_rest_client.resource.read = mock.Mock(return_value={"items": [{
                    "id": 654321,
                    "type": "ARCADIA_PROJECT_TGZ",
                    "attributes": {"platform": "linux", "other": "value"}
                }]})
                watcher._c_info.name = "c_info.name"
                watcher._c_info.get_release_numbers_from_resource = mock.Mock(return_value=(11, 22))
                watcher._c_info.releases_cfg__releasable_items = mock.Mock(return_value=[
                    ri.ReleasableItem(
                        name="mylovelyservice",
                        data=ri.SandboxResourceData("ARCADIA_PROJECT_TGZ", ttl=30, attributes={"platform": "linux"}),
                        deploy_infos=[ri.YaToolDeployInfo(ri.DeployService(
                            "bottles.mylovelyservice.formula.sandbox_id"
                        ))]
                    )
                ])
                result = watcher.last_deploy_proto(
                    ri.SandboxResourceData("ARCADIA_PROJECT_TGZ", ttl=111, attributes={"platform": "linux"}),
                    ri.YaToolDeployInfo(ri.DeployService("bottles.mylovelyservice.formula.sandbox_id"))
                )
                assert isinstance(result, list)
                assert len(result) == 1
                v = result[0]
                assert v.arc_hash == "arc_hash"
                assert v.svn_revision == "98776551"
                assert v.major_release_number == "11"
                assert v.minor_release_number == "22"
                assert v.sandbox_resource.resource_type == "ARCADIA_PROJECT_TGZ"
