import logging
from sandbox.projects.release_machine.helpers.request_helper import RequestHelper


U_API = "https://u.yandex-team.ru/api/v1/"


class UApi(RequestHelper):

    def __init__(self, timeout=30, ssl_verify=False):
        super(UApi, self).__init__(U_API, timeout, ssl_verify)
        self.headers = {
            'content-type': 'application/json'
        }

        self.logger = logging.getLogger(__name__)

    def get_on_duty(self, group):
        service_suffix = "duties/onduty/{}".format(group.name)
        result = self._do_get(service_suffix)
        return result["onDuty"]
