"""
    This file is ONLY for sandbox input parameters
"""
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.sandboxsdk.parameters as sp

from sandbox.projects.release_machine.components.configs import all as all_cfg


class ReleaseNum(sp.SandboxIntegerParameter):
    name = rm_const.RELEASE_NUMBER
    description = "Release number"
    default_value = 0
    required = False


class CheckedBeta(sp.SandboxStringParameter):
    """
    Checked beta is a beta with new (untested) program
    """
    name = 'checked_beta'
    description = 'Checked (new release) beta hostname'
    default_value = ''
    required = False


class CheckedBetaVideo(sp.SandboxStringParameter):
    """
    Checked beta is a beta with new (untested) program
    """
    name = 'checked_beta_video'
    description = 'Checked (new release) beta hostname for video'
    default_value = ''
    required = False


class CheckedBetaImages(sp.SandboxStringParameter):
    """
    Checked beta is a beta with new (untested) program
    """
    name = 'checked_beta_images'
    description = 'Checked (new release) beta hostname for images'
    default_value = ''
    required = False


class SampleBeta(sp.SandboxStringParameter):
    """
    Sample beta is a beta with good (stable, reference) version of your program.
    """
    name = 'sample_beta'
    description = 'Sample (reference) beta hostname'
    default_value = ''
    required = False


class ComponentName(sp.SandboxStringParameter):
    name = rm_const.COMPONENT_CTX_KEY
    description = "Component name"
    choices = zip(all_cfg.get_all_names(), all_cfg.get_all_names())
    default_value = ""
    required = False
