# -*- coding: utf-8 -*-
"""
    This file is ONLY for sandbox sdk2 input parameters
"""
from __future__ import unicode_literals


from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.release_machine.components.configs import all as all_cfg


def set_choices(choiceable, choices):
    for i in choices:
        choiceable.values[i] = choiceable.Value(value=i)


release_number = sdk2.parameters.Integer("Release number", default=0)


class BaseReleaseMachineParameters(binary_task.LastBinaryReleaseParameters):
    pass


class ComponentName2(BaseReleaseMachineParameters):
    with sdk2.parameters.String("Component name", default="") as component_name:
        set_choices(component_name, all_cfg.get_all_names())


class DefaultReleaseMachineParameters(ComponentName2):
    debug_mode = sdk2.parameters.Bool("Debug mode", default=False)


class ComponentNameResources(DefaultReleaseMachineParameters):
    use_build_tasks = sdk2.parameters.Bool("Use build task instead of resources", default=False)
    with use_build_tasks.value[True]:
        build_tasks = sdk2.parameters.List("Build task ids")
    with use_build_tasks.value[False]:
        component_resources = sdk2.parameters.Dict("Component name Resources")
