from sandbox import sdk2
from sandbox.projects.release_machine.core import ReleasedItem
from sandbox.projects.common import constants
from sandbox.projects.common import utils
from sandbox.projects.common.sdk_compat import task_helper as th
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components import all as rmc


class ComponentReleaseTemplate:
    """Fill default fields in release form (SEARCH-3115)."""

    @property
    def release_template(self):
        try:
            release_subject = self._get_release_subject()
        except Exception:
            release_subject = None
        if isinstance(self, sdk2.Task):
            return sdk2.task.ReleaseTemplate(subject=release_subject)
        if release_subject is None:
            release_subject = self.arcadia_info()[1]
        return self.ReleaseTemplate(subject=release_subject)

    def _get_released_resources(self, released_res):
        resource_type = released_res.resource_type
        if isinstance(resource_type, list):
            result = []
            for rtype in resource_type:
                if isinstance(self, sdk2.Task):
                    result.extend(list(sdk2.Resource[rtype.name].find(task=self).limit(1)))
                else:
                    result.extend(self.list_resources(released_res.resource_name))
            return result
        if isinstance(self, sdk2.Task):
            return list(sdk2.Resource[resource_type.name].find(task=self).limit(1))
        return self.list_resources(resource_type.name)

    def _get_release_subject(self):
        component_name = th.input_or_ctx_field(self, rm_const.COMPONENT_CTX_KEY, "")
        component = rmc.COMPONENTS[component_name]
        tag_url = th.input_or_ctx_field(self, constants.ARCADIA_URL_KEY)
        if not tag_url or not component:
            return None
        c_info = component()
        for released_res in c_info.releases_cfg__resources_info:
            released_resources = self._get_released_resources(released_res)
            if not released_resources:
                continue
            release_item = ReleasedItem(
                released_res.name, released_resources[0], released_res.build_ctx_key
            )
            major_num, minor_num = c_info.get_release_numbers(release_item)
            return c_info.get_stable_release_label(release_item, major_num or minor_num or release_item.build_task_id)
        return "{0}: {1}".format(component_name, utils.branch_tag_from_svn_url(tag_url)[1])
