from __future__ import unicode_literals

import json

from sandbox.projects.common import decorators
from sandbox.projects.release_machine.helpers import request_helper


class MortyClient(request_helper.RequestHelper):
    API_URL = "http://morty.z.yandex-team.ru/api/"

    def __init__(self, token=None):
        super(MortyClient, self).__init__()
        self.headers = {
            "Content-type": "application/json",
            "Accept": "application/json",
        }
        if token:
            self.headers["Authorization"] = "OAuth {token}".format(token=token)

    @decorators.retries(3, delay=2, backoff=4)
    def add_event(self, event=None):
        return self._do_post("morty.Scheduler/addEvent", data=json.dumps(event))
