# -*- coding:utf-8 -*-
from sandbox import sdk2

releasers = [
    "mvel",
    "ilyaturuntaev",
    "fizzzgen",
    "robot-srch-releaser",
    "robot-testenv",
]


class ReleaseEngineUI(sdk2.Resource):
    """Release Machine UI."""

    releasable = True
    auto_backup = True
    releasers = releasers


class ReleaseMachineBinary(sdk2.Resource):
    """Release Machine backend binary built with horadric2."""

    releasable = True
    auto_backup = True
    releasers = releasers
    arcadia_build_path = "release_machine/release_machine/bin/release_machine/release_machine"
    arcadia_build_name = "release_machine"


class SbPollerBinary(sdk2.Resource):
    """Release Machine SB Poller binary."""

    releasable = True
    auto_backup = True
    releasers = releasers
    arcadia_build_path = "release_machine/release_machine/src/sb_poller/bin/sb_poller"
    arcadia_build_name = "sb_poller"


class CiPollerBinary(sdk2.Resource):
    """Release Machine CI Poller binary."""

    releasable = True
    auto_backup = True
    releasers = releasers
    arcadia_build_path = "release_machine/release_machine/src/ci_poller/bin/ci_poller"
    arcadia_build_name = "ci_poller"


class ReleaseMachineIntegrationTestRelease(sdk2.resource.AbstractResource):
    """Test binary for release machine integration test."""
    releasable = True


class ReleaseMachineTestCiBinary(sdk2.resource.AbstractResource):
    """Test binary for release machine integration test."""
    releasable = True


class ReleaseMachineLaunchScripts(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = releasers
