# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.common.types import resource as ctr

releasers = [
    "mvel",
    "ilyaturuntaev",
    "fizzgen",
    "robot-srch-releaser",
]


class ChangelogHtml(sdk2.resource.Resource):
    """Changelog in html format."""
    auto_backup = True
    sync_upload_to_mds = False


class SimpleChangelog(sdk2.resource.Resource):
    auto_backup = True
    first_revision = sdk2.parameters.Integer("First revision of changelog")
    baseline_path = sdk2.parameters.String("Path of baseline item")
    baseline_revision = sdk2.parameters.Integer("Revision of baseline item")
    candidate_path = sdk2.parameters.String("Path of release candidate item")
    candidate_revision = sdk2.parameters.Integer("Revision of release candidate item")


class RELEASE_MACHINE_CHANGELOG(sdk2.resource.Resource):
    """Changelog in json format for release-machine components."""
    auto_backup = True
    changelog_type = sdk2.parameters.String("Changelog type")
    component = sdk2.parameters.String("Component")
    release_id = sdk2.parameters.String("Release id")
    major_release_num = sdk2.parameters.String("Major release number")
    minor_release_num = sdk2.parameters.String("Minor release number")
    restart_policy = ctr.RestartPolicy.RESET

    first_rev = sdk2.parameters.Integer("First rev")
    last_rev = sdk2.parameters.Integer("Last rev")
    sync_upload_to_mds = False


class MergeConflicts(sdk2.resource.Resource):
    """Directory with `svn diff` for conflict paths while merge."""
    auto_backup = True


class PortoLayerReleaseViewer(sdk2.Resource):
    """Porto layer for release viewer service."""
    auto_backup = True
    releasable = True
    releasers = releasers


class SVNREVISION_PATCHER(sdk2.resource.AbstractResource):
    """SVN Revision patcher (RMDEV-365)."""
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = [
        "mvel",
        "kulikov",
    ]


class RELEASE_MACHINE_TEST_TAGGED_RELEASE(sdk2.resource.AbstractResource):
    """Test binary for release machine tagged test."""
    releasable = True


class TELEGRAM_MESSAGE(sdk2.resource.AbstractResource):
    """Stores telegram messages that are too long to be sent in one message. Used by SendTelegramMessages"""
    auto_backup = True


class ScheduledRmReleaseData(sdk2.resource.Resource):
    """Release data, used for scheduling releases via Morty (RMDEV-1771)."""
    auto_backup = True
    deploy_system = sdk2.parameters.String("Deploy system")
    rm_component = sdk2.parameters.String("Release machine component name")
    major_release_num = sdk2.parameters.String("Major release number")
    minor_release_num = sdk2.parameters.String("Minor release number")
    releasable = True
    sync_upload_to_mds = False


class RELEASE_MACHINE_CONFIG_CRAWLER_REPORT(sdk2.resource.AbstractResource):
    """Stores ReleaseMachineConfigCrawler report"""


class RM_ALEMBIC_BINARY(sdk2.resource.AbstractResource):
    """Alembic binary (https://alembic.sqlalchemy.org/en/latest/)"""
    releasable = True


class RM_SOLOMON_AGENT_BINARY(sdk2.resource.AbstractResource):
    """Solomon Agent binary (https://wiki.yandex-team.ru/solomon/agent)"""
    releasable = True


class ICEFLAME_PERF_DATA(sdk2.resource.AbstractResource):
    """IceFlame perf intermediate data"""
    releasable = False
    executable = False


class METRICS_TEMPLATE_RESOURCE(sdk2.Resource):
    releasable = True
    releasable = True  # SANDBOX-4609
    executable = False

    releasers = [
        "RELEASE_MACHINE",
        "SEARCH-RELEASERS",
        "EXPERIMENTS",
        "ilyaturuntaev",
        "mvel",
        "natapolienko",
    ]
