# -*- coding: utf-8 -*-
"""
!!! DEPRECATED !!!
If you need notifications in your release machine, please, consider using new notifications.
Doc: https://wiki.yandex-team.ru/releasemachine/notifications/
If there is not enough functionality, please, contact RM DEV TEAM!
"""

import six
import datetime
import functools
import logging
import re
import requests
import types
import urllib3.exceptions as urllib_exc

import sandbox.projects.release_machine.components.configs.all as all_configs
from sandbox.projects.release_machine.components.configs.rtcc import RtccCfg
from sandbox.projects.release_machine.components.configs.begemot import BegemotCfg
from sandbox.common.types.task import Status
from sandbox.projects.common import link_builder as lb
from sandbox.projects.common import decorators
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.common import requests_wrapper
from sandbox.projects.common.sdk_compat import task_helper as rm_th
from sandbox.projects.release_machine.components import all as rmc
from sandbox.projects.release_machine import security as rm_sec
from sandbox.projects.release_machine.core import const

import sandbox.projects.release_machine.helpers.responsibility_helper as rm_responsibility
import sandbox.projects.release_machine.notify_helper as nh
import sandbox.projects.common.sdk_compat.task_helper as th


LOGGER = logging.getLogger(__name__)
TM_MESSAGE = "tm_message"
COMPONENT_NAMES = "component_names"
COMMIT_MESSAGE_MAX_CHARS = 120

UNKNOWN_DATABASE = 'unknown'

RE_TASK_DESCR = re.compile(r".*(\<.*?\>.*?\</.*?\>)")
RE_TE_ERROR = re.compile(r".*(\<.*?\>TestEnv\</.*?\>)")


class TransportType(object):
    TELEGRAM = "telegram"
    Q_MESSENGER = "q_messenger"
    EMAIL = "email"


class StandardMessage(object):
    @staticmethod
    def _comp_name(task):
        return th.input_field(task, const.COMPONENT_CTX_KEY, const.RMNames.DEFAULT)

    @staticmethod
    def all_right(task):
        return "[{}] is all right, task {}".format(
            StandardMessage._comp_name(task),
            lb.task_link(task.id)
        )

    @staticmethod
    def some_trouble(task):
        return "[{}] trouble in task {} ({})".format(
            StandardMessage._comp_name(task),
            lb.task_link(task.id),
            task.type
        )


def _send_message(self, people, message):
    try:
        if self.id < 100000:  # local sandbox
            return
    except Exception:
        pass
    try:
        nh.telegram(self, message=message(self), people=people)
    except Exception:
        nh.telegram(self, message=message(), people=people)


def method_deco(obj, people, message, exception, flag):
    @functools.wraps(obj)
    def notifiable_func(self, *args, **kwargs):
        if exception:
            try:
                result = obj(self, *args, **kwargs)
            except Exception:
                _send_message(self, people, message)
                raise
            return result
        elif flag:
            th.ctx_field_set(self, "notify_by_tm", False)
            result = obj(self, *args, **kwargs)
            if th.ctx_field(self, "notify_by_tm", False):
                _send_message(self, people, message)
            return result

        _send_message(self, people, message)
        return obj(self, *args, **kwargs)

    return notifiable_func


def class_deco(obj, people, message, on_trouble, on_success):
    if on_trouble:
        old_on_break = getattr(obj, "on_break")
        old_on_fail = getattr(obj, "on_failure")

        def on_break(self, *args, **kwargs):
            _send_message(self, people, message)
            return old_on_break(self, *args, **kwargs)

        def on_failure(self, *args, **kwargs):
            _send_message(self, people, message)
            return old_on_fail(self, *args, **kwargs)

        setattr(obj, "on_failure", on_failure)
        setattr(obj, "on_break", on_break)
    if on_success:
        old_on_success = getattr(obj, "on_success")

        def on_success(self, *args, **kwargs):
            _send_message(self, people, message)
            return old_on_success(self, *args, **kwargs)

        setattr(obj, "on_success", on_success)
    return obj


def notify(
    people,
    message,
    exception=False,
    flag=False,
    on_trouble=True,
    on_success=False,
):
    """
    Decorator, which sends message by telegram.

    Default mode for method decorator - always send notification
    Default mode for class decorator - send notification on_break && on failure
    It maybe also work on functions, which first argument is self.
    Don't know how it works with static_method

    :param people: people, who always get notifications,
    :param message: function which generated message
    :param exception: used for method decorator, notify if method throw exception
    :param flag: used for method decorator, notify if self.ctx["notify_by_tm"] == True
    :param on_trouble: used for class decorator, notify on_break() && on_failure()
    :param on_success: used for class decorator, notify on_success()
    :return:
    """
    def decorator(obj):
        if isinstance(obj, types.MethodType) or isinstance(obj, types.FunctionType):
            return method_deco(obj, people, message, exception, flag)
        else:
            return class_deco(obj, people, message, on_trouble, on_success)
    return decorator


def get_mention(task, person=None, component_name=None):
    LOGGER.info('[get_mention] Person: `%s`, component: `%s`', person, component_name)
    token = rm_sec.get_rm_token(task)

    if person is None:
        person = rmc.get_component(component_name).st_assignee
        LOGGER.info('[get_mention] Person set from component ST assignee to `%s`', person)

    person = rm_responsibility.get_responsible_user_login(person)

    # todo: move to staff helper
    LOGGER.debug("Requesting staff")
    staff_response = requests_wrapper.get_r(
        const.Urls.STAFF_API + "persons",
        params={
            "_one": 1,
            "login": person,
        },
        headers={
            "Authorization": "OAuth {}".format(token),
        }
    )
    if staff_response.status_code == requests.codes.ok:
        staff_json = staff_response.json()
        if 'accounts' in staff_json:
            for acc in staff_json['accounts']:
                if not acc.get('private', True):
                    if acc.get('type') == 'telegram':
                        return acc['value']

    raise Exception('Telegram login for person `{}` was not found'.format(person))


def _get_people_groups(component_name, rm_task_type, status):
    nf_recipient = set()
    LOGGER.debug("_get_people_groups for rm_task_type `%s` and status `%s`", rm_task_type, status)

    for people_group in const.PeopleGroups.ALL:
        if isinstance(const.rm_config[people_group][status], types.BooleanType):
            LOGGER.debug("_get_people_groups: added people_group `%s` on [bool]", people_group)
            nf_recipient.add(people_group)

        if isinstance(const.rm_config[people_group][status], types.ListType):
            if rm_task_type in const.rm_config[people_group][status]:
                LOGGER.debug("_get_people_groups: added people_group `%s` on [list]", people_group)
                nf_recipient.add(people_group)

        if isinstance(const.rm_config[people_group][status], types.DictType):
            if rm_task_type in const.rm_config[people_group][status].get(component_name, []):
                LOGGER.debug("_get_people_groups: added people_group `%s` on [dict]", people_group)
                nf_recipient.add(people_group)

    LOGGER.debug("Got people groups: %s", nf_recipient)
    return nf_recipient


def _gen_message(task, component_name, status, rm_task_type, transport_type=TransportType.TELEGRAM):
    LOGGER.info('[_gen_message] Generating message for %s', component_name)

    message = ""

    # calculate mention message
    mention_message = ''
    if component_name != const.RMNames.DEFAULT:
        try:
            component_config = all_configs.ALL_CONFIGS[component_name]()
            responsible = component_config.responsible or "mvel"
            mention_message = u"@{},\n".format(get_mention(
                task=task,
                person=responsible,
                component_name=component_name,
            ))
        except Exception as exc:
            mention_message = ""
            eh.log_exception("[_gen_message]: Mention doesn't work, error", exc)
    else:
        LOGGER.error('Component `%s` does not exists, cannot mention owner', component_name)

    if task.info:
        try:
            LOGGER.debug("Task info: %s", task.info)
            err_message = re.sub(r'<div.*?>.*?</div>', '', str(task.info))
            err_message = re.sub('<hr/>', '', err_message)
            if rm_task_type == const.TaskTypes.GENERATE_BETA.name:
                try:
                    descr_task = RE_TASK_DESCR.search(rm_th.get_task_description(task)).group(1)
                    err_message += RE_TE_ERROR.search(descr_task).group(0).replace(
                        'TestEnv',
                        'Test history'
                    )
                except Exception as err:
                    eh.log_exception("Cannot add test history to notify message", err)

            err_message = filter(lambda s: "You are using" not in s, str(err_message).split("\n"))
            if len(err_message) > 5:
                err_message = err_message[-6:]

            err_message = map(lambda x: x[:280], err_message)
            err_message = "\n".join(err_message)
            err_message += "..."
        except Exception as err:
            eh.log_exception("Cannot construct error message", err)
            err_message = "[Cannot construct error report because of error {}]".format(err)
    else:
        try:
            err_message = rm_th.get_task_description(task)
            if "Resource check" in err_message:
                return ""
        except Exception:
            err_message = "unknown error"

    database = th.ctx_field(task, 'testenv_database', UNKNOWN_DATABASE)
    if status in [const.RMStatus.on_failure]:
        if rm_task_type == const.TaskTypes.VIDEO_FORMULAS.name:
            # Shut up notifications for them until they setup new system properly.
            # Please ask mvel@ before enabling this back.
            LOGGER.info('All notifications for VIDEO_FORMULAS were silenced')
            return ''

        if rm_task_type == const.TaskTypes.LAUNCH_METRICS.name:
            # LAUNCH_METRICS failures are too often
            if component_name == const.RMNames.DEFAULT:
                LOGGER.info('All notifications for LAUNCH_METRICS failures were silenced for unknown component')
                return ''

        if rm_task_type == const.TaskTypes.BUILD.name:
            if "trunk" in rm_th.get_task_description(task):
                LOGGER.info('Skipped notification for `trunk` database')
                return ""

        if rm_task_type == const.TaskTypes.RELEASE_RM_COMPONENT.name:
            if transport_type == TransportType.TELEGRAM:
                message = (
                    '{mention_message}Problem with `{component_name}` release task: {task_link} '
                    '(<strong>{task_type}</strong>) '
                    'in {database} database\ninfo: {error_message}'.format(
                        mention_message=mention_message,
                        component_name=component_name,
                        task_link=lb.task_link(task.id),
                        task_type=task.type,
                        database=database,
                        error_message=err_message,
                    )
                )
            else:
                message = (
                    '{mention} Problem with `{component_name}` release task: {task_link} (**{task_type}**) '
                    'in {database} database\nInfo: {error_message}'.format(
                        mention=mention_message,
                        component_name=component_name,
                        task_link=lb.task_link(task.id, plain=True),
                        task_type=task.type,
                        database=database,
                        error_message=err_message,
                    )
                )

        else:
            if transport_type == TransportType.TELEGRAM:
                message = (
                    '{mention_message}Failure in task {task_link} (<strong>{task_type}</strong>)\n'
                    '[{component_name}][{database}]\n{error_message}'.format(
                        mention_message=mention_message,
                        task_link=lb.task_link(task.id),
                        task_type=task.type,
                        component_name=component_name,
                        database=database,
                        error_message=err_message,
                    )
                )
            else:
                message = (
                    '{mention_message}Failure in task {task_link} (**{task_type}**)\n'
                    '[{component_name}][{database}]\n{error_message}'.format(
                        mention_message=mention_message,
                        task_link=lb.task_link(task.id, plain=True),
                        task_type=task.type,
                        component_name=component_name,
                        database=database,
                        error_message=err_message,
                    )
                )

    if status in [const.RMStatus.on_break]:
        if th.task_status(task.id) not in [Status.STOPPED]:
            message = "Break (exception) in task {} (<strong>{}</strong>)\n[{}][{}]\n info: {}".format(
                lb.task_link(task.id),
                task.type,
                component_name,
                database,
                err_message,
            )

    if status in [const.RMStatus.on_success]:
        if th.ctx_field(task, TM_MESSAGE, ""):
            message = th.ctx_field(task, TM_MESSAGE, "")
        else:
            message = "Success. Task {}".format(lb.task_link(task.id))

    if status in [const.RMStatus.custom]:
        if th.ctx_field(task, TM_MESSAGE, ""):
            if component_name in [BegemotCfg.name] and datetime.datetime.now().weekday() >= 5:
                return ""
            message = th.ctx_field(task, TM_MESSAGE, "")

    return message


def get_rm_task_type(task):
    for task_types in const.TaskTypes.ALL_TYPES:
        if str(task.type) in task_types.tasks:
            return task_types.name
    return const.TaskTypes.OTHER.name


_TASKS_SEPARATED_TO_Q = [
    'TEST_XML_SEARCH_2',
]


def _get_people(component_name, group_ppl, task_name):
    ppl = set()

    if component_name not in rmc.get_component_names():
        if task_name not in _TASKS_SEPARATED_TO_Q:
            # See RMDEV-673 as an example of possible situation
            ppl.add("rm_maintainers")
            return ppl

    c_info = rmc.get_component(component_name)
    if const.PeopleGroups.RM_MAINTAINERS == group_ppl:
        ppl.add("rm_maintainers")

    if const.PeopleGroups.CHAT == group_ppl:
        if c_info.notify_cfg__tg__chats:
            for chat in c_info.notify_cfg__tg__chats:
                ppl.add(chat)

    if const.PeopleGroups.RESP == group_ppl:
        ppl.add(c_info.get_responsible_for_release())

    if const.PeopleGroups.NOTIFY_TESTER == group_ppl:
        ppl.add("mvel")

    return ppl


def _send_message2(task, man, message_telegram, message_q=None, pin=False):
    if message_q is None:
        message_q = message_telegram

    if man in const.RM_USERS:
        LOGGER.info("Man `%s` was found in const.RM_USERS, trying to send notification", man)
        try:
            nh.telegram(task, chat_ids=[const.RM_USERS[man].telegram], message=message_telegram, pin=pin)
            if const.RM_USERS[man].q_messenger:
                nh.q_messenger(task, chat_ids=[const.RM_USERS[man].q_messenger], message=message_q)
        except Exception as e:
            LOGGER.exception("Unable to send message to %s:\n%s", man, e)
            nh.telegram(
                task,
                chat_ids=[const.RM_USERS["rm_maintainers"].telegram],
                message="No message for {}".format(task.id),
            )
    else:
        LOGGER.info("Defaulting to `rm_maintainers`")
        nh.telegram(
            task,
            chat_ids=[const.RM_USERS["rm_maintainers"].telegram],
            message="{} can't get message".format(man)
        )


def create_notify(task, status, ppl, pin=False):
    component_name = th.input_or_ctx_field(task, const.COMPONENT_CTX_KEY, const.RMNames.DEFAULT)
    # Do not send notifications for not release machine task launches (INFRADUTY-3947)
    release_machine_mode = th.input_or_ctx_field(task, "release_machine_mode", True)
    if not release_machine_mode and not component_name:
        LOGGER.debug("Not release machine mode. do nothing")
        return

    if component_name == const.RMNames.DEFAULT or not component_name:
        component_name = th.ctx_field(task, COMPONENT_NAMES, const.RMNames.DEFAULT).split(" ")
        LOGGER.debug("Extracted component name `%s`", component_name)

    if isinstance(component_name, six.string_types):
        comp_names = [component_name]
    else:
        comp_names = component_name

    LOGGER.info(
        "[create_notify] Component names: %s, status: %s, task status: %s",
        ", ".join(comp_names), status, task.status,
    )
    if task.id < 100000:
        # testing mode, afaik
        return

    for component_name in comp_names:
        if not _check_task(task, component_name):
            continue

        rm_task_type = get_rm_task_type(task)
        LOGGER.info("[create_notify] Task type %s, rm_task_type %s", task.type, rm_task_type)

        message_telegram = _gen_message(
            task, component_name, status, rm_task_type,
            transport_type=TransportType.TELEGRAM,
        )
        message_q = _gen_message(
            task, component_name, status, rm_task_type,
            transport_type=TransportType.Q_MESSENGER,
        )
        if not message_telegram:
            LOGGER.debug("[create_notify] Message is empty, skipping")
            return

        people = set(ppl)
        for group_ppl in _get_people_groups(component_name, rm_task_type, status):
            people |= set(_get_people(component_name, group_ppl, task.type))

        if set(people) == set(ppl):
            LOGGER.info(
                "[create_notify] No additional people want to receive this notifications: %s",
                list(set(people)),
            )
            return

        LOGGER.info("[create_notify] Sending message to people: %s", people)

        for man in people:
            _send_message2(
                task=task,
                man=man,
                message_telegram=message_telegram,
                message_q=message_q,
                pin=pin,
            )

        if th.ctx_field(task, TM_MESSAGE, ""):
            th.ctx_field_set(task, TM_MESSAGE, "")
        LOGGER.debug('[create_notify] Notification text was cleared')


def _check_task(task, comp=None):
    """Check if tasks is allowed to send TM notifications."""
    warn_message_fmt = "Disabled telegram messages for `%s`"

    if task.owner == "REVIEW-CHECK" and comp not in [RtccCfg.name]:
        # Don't allow to send rm notifies for review checks
        LOGGER.debug(warn_message_fmt, "review checks")
        return False

    if th.input_field(task, "debug_mode"):
        # Don't allow to send TM notifies for tasks with debug mode
        LOGGER.debug(warn_message_fmt, "debug mode")
        return False

    LOGGER.debug("_check_task: Task type is %r", task.type)
    allowed_copied_tasks = frozenset(["MERGE_TO_STABLE"])
    if th.ctx_field(task, "copy_of") and str(task.type) not in allowed_copied_tasks:
        # Don't allow to send TM notifies for copied task instead of white list
        LOGGER.debug("Task type is %r", task.type)
        LOGGER.debug(
            warn_message_fmt,
            "copied tasks, allowed tasks: {}".format(", ".join(allowed_copied_tasks))
        )
        return False

    if th.ctx_field(task, "testenv_resource_check", False):
        # Don't allow to send TM notifies for resource check tasks
        LOGGER.debug(
            warn_message_fmt,
            "testenv resource check: {}".format(th.ctx_field(task, "testenv_resource_check"))
        )
        return False

    return True


@decorators.retries(3, exceptions=(urllib_exc.NewConnectionError,))
def send_tm_message(task, message, chat_ids, pin=False, **kwargs):
    if not _check_task(task):
        LOGGER.debug("Task %s check was not passed, skipping", task)
        return

    LOGGER.debug(
        "Try to send notify to `%s`, messages id `%s`, pin `%s`, kwargs `%s`",
        chat_ids, message, pin, kwargs
    )
    nh.telegram(task, chat_ids=chat_ids, message=message, pin=pin, **kwargs)


def notify2(people=()):
    def decorator(cls):

        def method_gen(old, status, people, pin=False):
            def method(self, *args, **kwargs):
                try:
                    LOGGER.debug("notify2 args: %s\nkwargs: %s", args, kwargs)

                    if u'STOPPED' not in args:
                        if status not in getattr(self, "RM_NOTIFY_STATUSES_DO_NOT_SEND", ()):
                            create_notify(self, status, people)

                except Exception as exc:
                    eh.log_exception("notify2.create_notify error", exc)
                return old(self, *args, **kwargs)
            return method

        for status in const.RMStatus.ALL:
            old = getattr(cls, status)
            setattr(cls, status, method_gen(old, status, people))

        def send_tm_notify(self, pin=False):
            try:
                create_notify(self, const.RMStatus.custom, people, pin)
            except Exception as exc:
                eh.log_exception("notify2.send_tm_notify error", exc)
        setattr(cls, "send_tm_notify", send_tm_notify)

        return cls
    return decorator


def notify_if_acceptance_delayed(c_info, task, current_launch_time_sec):
    """
    Send telegram notification if the acceptance task given in `task` runs for too long.

    I.e.: launch time exceeds max execution time for such tasks specified in the given component configuration file

    :param c_info: component's c_info object
    :param task: SB Task object
    :param current_launch_time_sec: launch execution time in seconds
    :return: `None` if no errors occurred, error message otherwise
    """
    try:
        message = c_info.notify_cfg__tg__get_acceptance_delay_message(
            task.id,
            task.type,
            current_launch_time_sec,
        )
        if not message:
            return

        for chat in c_info.notify_cfg__tg__chats:
            _send_message2(
                task=task,
                man=chat,
                message_telegram=message,
            )
    except Exception as e:
        LOGGER.error(
            'Unable to send acceptance delay notification for %s',
            c_info.name
        )
        return e.message
