"""
    Temporary file. Please, do not put code here!
    Probably, you can find better place for your code.
"""

from sandbox.common import rest as sandbox_rest


def get_tasks_fields(fields, filters=None, sandbox_client=None):
    if sandbox_client is None:
        sandbox_client = sandbox_rest.Client()
    data = {
        "fields": fields,
        "hidden": True,
        "children": True,
    }
    if filters:
        data.update(filters)

    return sandbox_client.task[data]["items"]


def get_task_fields(task_id, fields, sandbox_client=None):
    return get_tasks_fields(fields, {"limit": 1, "id": task_id}, sandbox_client)[0]


def get_task_field(task_id, field, sandbox_client=None, default=None):
    return get_task_fields(task_id, [field], sandbox_client).get(field, default)


def get_input_field(task_id, field, sandbox_client=None, default=None):
    return get_task_field(task_id, 'input_parameters.{}'.format(field), sandbox_client, default)


def get_ctx_field(task_id, field, sandbox_client=None, default=None):
    return get_task_field(task_id, 'context.{}'.format(field), sandbox_client, default)


def get_input_or_ctx_field(task_id, field, sandbox_client=None, default=None):
    input_field = get_input_field(task_id, field, sandbox_client)
    if input_field is not None:
        return input_field
    return get_ctx_field(task_id, field, sandbox_client, default)


def get_tasks_to_check(task):
    task_ids_str = task.Parameters.tasks_to_check.replace(" ", "")
    if not task_ids_str:
        return []
    return task_ids_str.split(",")
