import sandbox.common.errors as err
import sandbox.sdk2 as sdk2
import sandbox.projects.release_machine.core.const as rm_const


def get_rm_token(task, token_name=rm_const.COMMON_TOKEN_NAME):
    try:
        return sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, token_name)
    except err.VaultError:
        raise err.VaultError(
            "Key with name '{key_name}' and owner '{key_owner}' "
            "is not available for task owner '{task_owner}'.\n"
            "Please, ask somebody from '{key_owner}' for access".format(
                key_owner=rm_const.COMMON_TOKEN_OWNER,
                key_name=token_name,
                task_owner=task.owner if task else '???'
            )
        )
