# coding: utf-8

import logging
import tempfile
import shutil

from sandbox import sdk2

from sandbox.projects.common import utils
from sandbox.projects.common import file_utils

from sandbox.projects.release_machine import resources as rm_resources


def patch_svnrevision(file_name, svn_info_text, output_file_name=None):
    """
    :param file_name: binary to patch [in/out]
    :param svn_info_text: svn info text started with `Svn info:`, like --svnrevision prints
    :param output_file_name [optional] output file name (will output to `file_name` if omitted)
    """
    logging.info(
        "Patching `%s` to `%s` with svnrevision info\n%s\n",
        file_name,
        output_file_name if output_file_name else '<None>',
        svn_info_text,
    )
    patcher = utils.sync_last_stable_resource(rm_resources.SVNREVISION_PATCHER)
    patch_name = 'svn_info_patch.txt'
    file_utils.write_file(patch_name, svn_info_text)

    need_to_move = False
    real_output_file_name = output_file_name
    if output_file_name is None or file_name == output_file_name:
        need_to_move = True
        real_output_file_name = tempfile.mktemp(dir="./")

    sdk2.helpers.subprocess.check_call([
        patcher,
        file_name,
        patch_name,
        real_output_file_name,
    ])
    logging.info("Binary `%s` successfully patched to `%s`", file_name, real_output_file_name)
    if need_to_move:
        logging.info("Copying `%s` to `%s` after patching", real_output_file_name, file_name)
        shutil.copy(real_output_file_name, file_name)
