from __future__ import unicode_literals

from sandbox.projects.release_machine import table_formatter

INIT_TABLES = [
    (
        "key1",
        "Here will be\nmy custom comment to this table",
        table_formatter.TableData(
            ("Head 1", "Head 2"),
            [
                ("cell 1 1", "cell 1 2"),
                ("cell 2 1", "cell 2 2"),
            ]
        ),
    ),
    (
        "key2",
        "Another comment",
        table_formatter.TableData(
            ("Head 1", "Head 2"),
            [("cell 1", "cell 2")]
        ),
    ),
]

WIKI_TABLES_1 = """<# <!-- MARKER --> #>
%%(comments)
{
  "comment_marker": "MARKER",
  "tables": [
    {
      "table_comment": "Here will be\\nmy custom comment to this table",
      "table_content": {
        "header": [
          "Head 1",
          "Head 2"
        ],
        "rows": [
          [
            "cell 1 1",
            "cell 1 2"
          ],
          [
            "cell 2 1",
            "cell 2 2"
          ]
        ]
      },
      "table_key": "key1"
    },
    {
      "table_comment": "Another comment",
      "table_content": {
        "header": [
          "Head 1",
          "Head 2"
        ],
        "rows": [
          [
            "cell 1",
            "cell 2"
          ]
        ]
      },
      "table_key": "key2"
    }
  ]
}
%%
===== MARKER

Here will be
my custom comment to this table
#|
|| **Head 1** | **Head 2** ||
|| cell 1 1 | cell 1 2 ||
|| cell 2 1 | cell 2 2 ||
|#

Another comment
#|
|| **Head 1** | **Head 2** ||
|| cell 1 | cell 2 ||
|#

<# <!-- MARKER --> #>"""

WIKI_JSON_TO_UPDATE = {
    "comment_marker": "MARKER",
    "tables": [
        # the order of table is intentionally changed to check update by table key
        {
            "table_key": "key2",
            "table_comment": "Another comment",
            "table_content": {
                "header": ["Head 1", "Head 2"],
                "rows": [
                    ["cell 1", "cell 2"],
                    ["added row cell 1", "added row cell 2"],
                ],
            }
        },
        {
            "table_key": "key1",
            "table_comment": "Updated comment",
            "table_content": {
                "header": ["Head 1", "Updated Head 2"],
                "rows": [
                    # this row is missing to check row update mod by column key
                    ["cell 2 1", "updated cell 2 2"],
                ],
            }
        },
        {
            "table_key": "key3",
            "table_comment": "Added table",
            "table_content": {
                "header": ["Head"],
                "rows": [["cell"]],
            }
        },
    ]
}

WIKI_TABLES_2 = """<# <!-- MARKER --> #>
%%(comments)
{
  "comment_marker": "MARKER",
  "tables": [
    {
      "table_comment": "Updated comment",
      "table_content": {
        "header": [
          "Head 1",
          "Updated Head 2"
        ],
        "rows": [
          [
            "cell 1 1",
            "cell 1 2"
          ],
          [
            "cell 2 1",
            "updated cell 2 2"
          ]
        ]
      },
      "table_key": "key1"
    },
    {
      "table_comment": "Another comment",
      "table_content": {
        "header": [
          "Head 1",
          "Head 2"
        ],
        "rows": [
          [
            "cell 1",
            "cell 2"
          ],
          [
            "added row cell 1",
            "added row cell 2"
          ]
        ]
      },
      "table_key": "key2"
    },
    {
      "table_comment": "Added table",
      "table_content": {
        "header": [
          "Head"
        ],
        "rows": [
          [
            "cell"
          ]
        ]
      },
      "table_key": "key3"
    }
  ]
}
%%
===== MARKER

Updated comment
#|
|| **Head 1** | **Updated Head 2** ||
|| cell 1 1 | cell 1 2 ||
|| cell 2 1 | updated cell 2 2 ||
|#

Another comment
#|
|| **Head 1** | **Head 2** ||
|| cell 1 | cell 2 ||
|| added row cell 1 | added row cell 2 ||
|#

Added table
#|
|| **Head** ||
|| cell ||
|#

<# <!-- MARKER --> #>"""


def test__updatable_tables_wiki_dump():
    assert str(table_formatter.UpdatableTablesWiki("MARKER", INIT_TABLES)) == WIKI_TABLES_1


def test__updatable_tables_wiki_updated():
    tables_obj = table_formatter.UpdatableTablesWiki("MARKER", INIT_TABLES)
    tables_obj_new = table_formatter.UpdatableTablesWiki.from_json(WIKI_JSON_TO_UPDATE)
    tables_obj.update(tables_obj_new)
    assert str(tables_obj) == WIKI_TABLES_2
    assert str(tables_obj) == str(table_formatter.UpdatableTablesWiki.from_wiki(WIKI_TABLES_2))
