# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.task_env as task_env
import sandbox.projects.release_machine.helpers.startrek_helper as rm_st
import sandbox.projects.release_machine.tasks.base_task as rm_bt
import sandbox.projects.release_machine.security as rm_sec
import sandbox.sdk2 as sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.release_machine import input_params2 as rm_params


class CommentStartrekTicket(rm_bt.BaseReleaseMachineTask):
    class Requirements(task_env.StartrekRequirements):
        pass

    class Parameters(rm_params.BaseReleaseMachineParameters):
        _lbrp = binary_task.binary_release_parameters(stable=True)
        kill_timeout = 300  # 5 min
        issue_key = sdk2.parameters.String(
            "Startrek ticket key",
        )
        text = sdk2.parameters.String("Text")

    def on_execute(self):
        rm_bt.BaseReleaseMachineTask.on_execute(self)

        st_auth_token = rm_sec.get_rm_token(self)
        st_helper = rm_st.STHelper(st_auth_token)
        st_helper.comment_by_key(self.Parameters.issue_key, self.Parameters.text)
