# -*- coding: utf-8 -*-
import json
import logging

import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.core.task_env as task_env
import sandbox.projects.release_machine.helpers.ab_helper as rm_ab
import sandbox.projects.release_machine.input_params2 as rm_params
import sandbox.projects.release_machine.tasks.base_task as rm_bt
import sandbox.sdk2 as sdk2
from sandbox.projects.common import binary_task


class CreateAbTest(rm_bt.BaseReleaseMachineTask):
    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(rm_params.ComponentName2):
        _lbrp = binary_task.binary_release_parameters(stable=True)
        kill_timeout = 15 * 60  # 15 min
        data_for_testid = sdk2.parameters.String("Data for test id", multiline=True)
        debug_mode = sdk2.parameters.Bool("Use ab.test.yandex-team.ru instead of prod", default=True)

    def on_execute(self):
        rm_bt.BaseReleaseMachineTask.on_execute(self)
        # c_info = rmc.get_component(self.Parameters.component_name)
        ab_api = rm_ab.ABApi(
            token=sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, "ab_formulas_release_token"),
            test=self.Parameters.debug_mode,
        )
        data = {
            "queue_id": "1",
            "title": "Release production formulas",
            "type": "ABT",
            "params": self.Parameters.data_for_testid
        }
        logging.info("Try to create test id with data:\n%s", json.dumps(data, indent=2))
        self.Context.testid_created = ab_api.create_test_id(data)

    @property
    def footer(self):
        if self.Context.testid_created:
            url = rm_ab.ABApi.TEST_URL if self.Parameters.debug_mode else rm_ab.ABApi.PROD_URL
            return "Test id created: <a href={url}testid/{testid}>{testid}</a>".format(
                url=url, testid=self.Context.testid_created.get("testid")
            )
